/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.removeemptydirectories;

import com.syntevo.openapi.deprecated.gui.dialog.IDialogResultHandler;
import com.syntevo.openapi.deprecated.smartsvn.action.ActionServices;
import com.syntevo.openapi.deprecated.smartsvn.command.ISvnCommand;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnDirectory;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnDirectoryLocalState;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnEntryQuery;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.ISvnFileDirectoryAction;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.SelectedSvnDirectories;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.SelectedSvnFiles;
import com.syntevo.plugin.removeemptydirectories.REDSvnCommand;
import org.jetbrains.annotations.NotNull;

final class REDFileDirectoryAction
implements ISvnFileDirectoryAction {
    public static final String ID = "com.syntevo.removeEmptyDirectories.RemoveEmptyDirectories";

    public boolean isApplicable(@NotNull SelectedSvnFiles selectedFiles, @NotNull SelectedSvnDirectories selectedDirectories) {
        SvnDirectory directory = selectedDirectories.getDirectory();
        if (directory == null) {
            return false;
        }
        SvnDirectoryLocalState state = directory.getLocalState();
        return state == SvnDirectoryLocalState.CONFLICT || state == SvnDirectoryLocalState.COPIED || state == SvnDirectoryLocalState.HISTORY_SCHEDULED || state == SvnDirectoryLocalState.HISTORY_SCHEDULED_MODIFIED || state == SvnDirectoryLocalState.NESTED_ROOT || state == SvnDirectoryLocalState.MODIFIED || state == SvnDirectoryLocalState.UNCHANGED;
    }

    public void execute(@NotNull SelectedSvnFiles files, @NotNull SvnEntryQuery entryQuery, @NotNull ActionServices services) {
        throw new UnsupportedOperationException();
    }

    public void execute(final @NotNull SelectedSvnDirectories directories, @NotNull SvnEntryQuery entryQuery, final @NotNull ActionServices services) {
        services.getDialogDisplayer().showConfirmationDialogAsync("Remove Empty Directories", "Do you want to start searching for empty directories?", "Found empty directories will be marked for removal.", "Start", false, new IDialogResultHandler(){

            public void handleDialogResult(int value) {
                if (value != 2) {
                    return;
                }
                services.scheduleCommand((ISvnCommand)new REDSvnCommand(directories.getDirectory()), "Remove Empty Directories");
            }
        });
    }
}

