/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.jira.JiraPlugin;
import com.syntevo.plugin.jira.transport.JiraClient;
import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraIssueResolution;
import com.syntevo.plugin.jira.transport.JiraIssueStatus;
import com.syntevo.plugin.jira.transport.JiraIssueType;
import com.syntevo.plugin.jira.transport.JiraVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JiraSoapClient
extends JiraClient {
    private static final String JIRA_IN0 = "in0";
    private static final String JIRA_IN1 = "in1";
    private static final String JIRA_IN2 = "in2";
    private static final String JIRA_IN3 = "in3";
    private static final String JIRA_NAME = "name";
    private static final String JIRA_ARCHIVED = "archived";
    private static final String JIRA_RELEASED = "released";
    private static final String JIRA_FALSE = "false";
    private static final String JIRA_TRUE = "true";
    private static final String JIRA_REMOTE_FIELD_VALUE = "RemoteFieldValue";
    private static final String JIRA_GET_ISSUE = "getIssue";
    private static final String JIRA_GET_ISSUE_RESPONSE = "getIssueResponse";
    private static final String JIRA_GET_ISSUE_RETURN = "getIssueReturn";
    private static final String JIRA_GET_PROJECT_BY_KEY = "getProjectByKey";
    private static final String JIRA_GET_PROJECT_BY_KEY_RESPONSE = "getProjectByKeyResponse";
    private static final String JIRA_GET_PROJECT_BY_KEY_RETURN = "getProjectByKeyReturn";
    private static final String JIRA_GET_VERSIONS = "getVersions";
    private static final String JIRA_GET_VERSIONS_RESPONSE = "getVersionsResponse";
    private static final String JIRA_GET_VERSIONS_RETURN = "getVersionsReturn";
    private static final String JIRA_LOGIN = "login";
    private static final String JIRA_LOGIN_RESPONSE = "loginResponse";
    private static final String JIRA_LOGIN_RETURN = "loginReturn";
    private static final String JIRA_LOGOUT = "logout";
    private static final String JIRA_LOGOUT_RESPONSE = "logoutResponse";
    private static final String JIRA_LOGOUT_RETURN = "logoutReturn";
    private static final String JIRA_PROGRESS_WORKFLOW_ACTION = "progressWorkflowAction";
    private static final String JIRA_PROGRESS_WORKFLOW_ACTION_RESPONSE = "progressWorkflowActionResponse";
    private static final String JIRA_PROGRESS_WORKFLOW_ACTION_RETURN = "progressWorkflowActionReturn";
    private static final String SOAP_ENC_ARRAY = "soapenc:Array";
    private static final String SOAP_ENC_ARRAYTYPE = "soapenc:arrayType";
    private static final String SOAP_MULTIREF = "multiRef";
    private static final String SOAP_HREF = "href";
    private static final String SOAP_ID = "id";
    private static final String SOAP_FAULT = "Fault";
    private static final String SOAP_FAULTSTRING = "faultstring";
    private static final String SOAP_VALUES = "values";
    private static final String XSI_TYPE = "xsi:type";
    private static final String XSD_STRING = "xsd:string";
    private static final String RESOLVED_CONSTANT = System.getProperty("smartsvn.plugin.jira.resolvedConstant", System.getProperty("smartsvn.plugin.jira.resolved-constant", "5"));
    private final String endpoint;
    private String loginToken;
    private String loggedInUsername;
    private SOAPConnection connection;
    private MessageFactory messageFactory;
    private SOAPFactory soapFactory;

    public JiraSoapClient(BugtrackerConnection connection) {
        super(connection);
        this.endpoint = connection.getUrl() + "rpc/soap/jirasoapservice-v2";
    }

    public synchronized String getLoggedInUsername() {
        return this.loggedInUsername;
    }

    public synchronized boolean login() throws SOAPException, IOException {
        String username = this.getBugtrackerConnection().getUsername();
        if (username == null) {
            return false;
        }
        String password = this.getBugtrackerConnection().getPassword();
        SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
        this.connection = factory.createConnection();
        this.messageFactory = MessageFactory.newInstance();
        this.soapFactory = SOAPFactory.newInstance();
        SOAPMessage requestMessage = JiraSoapClient.createMessage(this.messageFactory);
        SOAPBodyElement request = JiraSoapClient.createBody(JIRA_LOGIN, requestMessage, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN0, username, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN1, password, this.soapFactory);
        try {
            SOAPBody responseBody = this.sendMessage(requestMessage, JIRA_LOGIN);
            Node response = JiraSoapClient.getUniqueChild((Node)responseBody, JIRA_LOGIN_RESPONSE, responseBody);
            Node responseReturn = JiraSoapClient.getUniqueChild(response, JIRA_LOGIN_RETURN, responseBody);
            this.loginToken = JiraSoapClient.extractText(responseReturn);
            this.getBugtrackerConnection().acknowledgeCredentials(this.loginToken != null);
            this.loggedInUsername = username;
            return this.loginToken != null;
        }
        catch (SOAPException ex) {
            this.loginToken = null;
            this.getBugtrackerConnection().acknowledgeCredentials(false);
            this.loggedInUsername = null;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean logout() throws SOAPException, IOException {
        Node responseReturn;
        if (this.loginToken == null) {
            return false;
        }
        SOAPMessage requestMessage = JiraSoapClient.createMessage(this.messageFactory);
        SOAPBodyElement request = JiraSoapClient.createBody(JIRA_LOGOUT, requestMessage, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN0, this.loginToken, this.soapFactory);
        SOAPBody responseBody = this.sendMessage(requestMessage, JIRA_LOGOUT);
        try {
            Node response = JiraSoapClient.getUniqueChild((Node)responseBody, JIRA_LOGOUT_RESPONSE, responseBody);
            responseReturn = JiraSoapClient.getUniqueChild(response, JIRA_LOGOUT_RETURN, responseBody);
        }
        finally {
            this.connection = null;
            this.messageFactory = null;
            this.soapFactory = null;
        }
        return JIRA_TRUE.equals(JiraSoapClient.extractText(responseReturn));
    }

    public synchronized String getProjectIDByKey(String key) throws SOAPException, IOException {
        SOAPMessage requestMessage = JiraSoapClient.createMessage(this.messageFactory);
        SOAPBodyElement request = JiraSoapClient.createBody(JIRA_GET_PROJECT_BY_KEY, requestMessage, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN0, this.loginToken, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN1, key, this.soapFactory);
        SOAPBody responseBody = this.sendMessage(requestMessage, "getProjectIDByKey");
        Node response = JiraSoapClient.getUniqueChild((Node)responseBody, JIRA_GET_PROJECT_BY_KEY_RESPONSE, responseBody);
        Node responseReturn = JiraSoapClient.getUniqueChild(response, JIRA_GET_PROJECT_BY_KEY_RETURN, responseBody);
        Node id = JiraSoapClient.getUniqueChild(responseReturn, SOAP_ID, responseBody);
        return JiraSoapClient.extractText(id);
    }

    public synchronized JiraIssue getIssueByKey(String issueKey) throws IOException, SOAPException {
        SOAPMessage requestMessage = JiraSoapClient.createMessage(this.messageFactory);
        SOAPBodyElement request = JiraSoapClient.createBody(JIRA_GET_ISSUE, requestMessage, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN0, this.loginToken, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN1, issueKey, this.soapFactory);
        SOAPBody responseBody = this.sendMessage(requestMessage, "getIssueByKey");
        Node response = JiraSoapClient.getUniqueChild((Node)responseBody, JIRA_GET_ISSUE_RESPONSE, responseBody);
        Node responseReturn = JiraSoapClient.getUniqueChild(response, JIRA_GET_ISSUE_RETURN, responseBody);
        JiraIssue issue = new JiraIssue();
        issue.setKey(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(responseReturn, SOAP_ID, responseBody)), issueKey);
        issue.setSummary(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(responseReturn, "summary", responseBody)));
        issue.setAssignee(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(responseReturn, "assignee", responseBody)));
        issue.setType(JiraIssueType.parseFromId(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(responseReturn, "type", responseBody))));
        issue.setStatus(JiraIssueStatus.parseFromId(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(responseReturn, "status", responseBody))));
        issue.setResolution(JiraIssueResolution.parseFromId(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(responseReturn, "resolution", responseBody))));
        List<Node> fixVersionNodes = JiraSoapClient.getChildren(responseReturn, "fixVersions", responseBody);
        ArrayList<JiraVersion> fixVersions = new ArrayList<JiraVersion>();
        for (Node fixVersionNode : fixVersionNodes) {
            fixVersions.add(new JiraVersion(JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(fixVersionNode, SOAP_ID, responseBody)), JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(fixVersionNode, JIRA_NAME, responseBody))));
        }
        issue.setFixVersions(fixVersions);
        return issue;
    }

    public synchronized List<JiraVersion> getUnreleasedVersionsByProjectKeyInOrder(String projectKey) throws SOAPException, IOException {
        SOAPMessage requestMessage = JiraSoapClient.createMessage(this.messageFactory);
        SOAPBodyElement request = JiraSoapClient.createBody(JIRA_GET_VERSIONS, requestMessage, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN0, this.loginToken, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN1, projectKey, this.soapFactory);
        SOAPBody responseBody = this.sendMessage(requestMessage, "getUnreleasedVersionsByProjectKeyInOrder");
        Node response = JiraSoapClient.getUniqueChild((Node)responseBody, JIRA_GET_VERSIONS_RESPONSE, responseBody);
        ArrayList<JiraVersion> versions = new ArrayList<JiraVersion>();
        for (Node node : JiraSoapClient.getChildren(response, JIRA_GET_VERSIONS_RETURN, responseBody)) {
            Node released;
            Node archived = JiraSoapClient.getUniqueChild(node, JIRA_ARCHIVED, responseBody);
            if (!JIRA_FALSE.equals(JiraSoapClient.extractText(archived)) || !JIRA_FALSE.equals(JiraSoapClient.extractText(released = JiraSoapClient.getUniqueChild(node, JIRA_RELEASED, responseBody)))) continue;
            String id = JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(node, SOAP_ID, responseBody));
            String name = JiraSoapClient.extractText(JiraSoapClient.getUniqueChild(node, JIRA_NAME, responseBody));
            versions.add(new JiraVersion(id, name));
        }
        return versions;
    }

    public synchronized boolean resolve(String issueKey, String assignee, JiraIssueResolution resolution, JiraVersion fixVersion) throws IOException, SOAPException {
        List<JiraVersion> fixVersions = fixVersion != null ? Collections.singletonList(fixVersion) : this.getFixVersionIDs(issueKey);
        SOAPMessage requestMessage = JiraSoapClient.createMessage(this.messageFactory);
        SOAPBodyElement request = JiraSoapClient.createBody(JIRA_PROGRESS_WORKFLOW_ACTION, requestMessage, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN0, this.loginToken, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN1, issueKey, this.soapFactory);
        JiraSoapClient.addString((SOAPElement)request, JIRA_IN2, RESOLVED_CONSTANT, this.soapFactory);
        SOAPElement remoteFieldValuesElement = JiraSoapClient.addArray((SOAPElement)request, JIRA_IN3, this.soapFactory);
        SOAPElement assigneeRemoteField = JiraSoapClient.addElement(remoteFieldValuesElement, JIRA_IN3, JIRA_REMOTE_FIELD_VALUE, this.soapFactory);
        JiraSoapClient.addString(assigneeRemoteField, SOAP_ID, "assignee", this.soapFactory);
        SOAPElement assigneeArray = JiraSoapClient.addArray(assigneeRemoteField, SOAP_VALUES, this.soapFactory);
        JiraSoapClient.addString(assigneeArray, SOAP_VALUES, assignee, this.soapFactory);
        SOAPElement resolutionRemoteField = JiraSoapClient.addElement(remoteFieldValuesElement, JIRA_IN3, JIRA_REMOTE_FIELD_VALUE, this.soapFactory);
        JiraSoapClient.addString(resolutionRemoteField, SOAP_ID, "resolution", this.soapFactory);
        SOAPElement resolutionArray = JiraSoapClient.addArray(resolutionRemoteField, SOAP_VALUES, this.soapFactory);
        JiraSoapClient.addString(resolutionArray, SOAP_VALUES, resolution.getJiraId(), this.soapFactory);
        SOAPElement fixVersionsRemoteField = JiraSoapClient.addElement(remoteFieldValuesElement, JIRA_IN3, JIRA_REMOTE_FIELD_VALUE, this.soapFactory);
        JiraSoapClient.addString(fixVersionsRemoteField, SOAP_ID, "fixVersions", this.soapFactory);
        SOAPElement fixVersionsArray = JiraSoapClient.addArray(fixVersionsRemoteField, SOAP_VALUES, this.soapFactory);
        for (JiraVersion aFixVersion : fixVersions) {
            JiraSoapClient.addString(fixVersionsArray, SOAP_VALUES, aFixVersion.getId(), this.soapFactory);
        }
        SOAPBody responseBody = this.sendMessage(requestMessage, "resolve");
        Node response = JiraSoapClient.getUniqueChild((Node)responseBody, JIRA_PROGRESS_WORKFLOW_ACTION_RESPONSE, responseBody);
        Node issue = JiraSoapClient.getUniqueChild(response, JIRA_PROGRESS_WORKFLOW_ACTION_RETURN, responseBody);
        Node status = JiraSoapClient.getUniqueChild(issue, "status", responseBody);
        return RESOLVED_CONSTANT.equals(JiraSoapClient.extractText(status));
    }

    private SOAPBody sendMessage(SOAPMessage request, String requestTitle) throws SOAPException, IOException {
        if (JiraPlugin.LOGGER.isDebugEnabled()) {
            JiraPlugin.LOGGER.debug("Sending request '" + requestTitle + "' to " + this.endpoint);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            request.writeTo((OutputStream)out);
            JiraPlugin.LOGGER.debug(new String(out.toByteArray()));
        }
        try {
            SOAPMessage response = this.connection.call(request, (Object)this.createConnectableURL(new URL(this.endpoint)));
            this.getBugtrackerConnection().acknowledgeSSLClientCertificate(true);
            return response.getSOAPBody();
        }
        catch (SSLException | SOAPException ex) {
            JiraPlugin.LOGGER.debug("Received error: " + ex.getMessage(), ex);
            JiraSoapClient.checkSSLException((Exception)ex, this.getBugtrackerConnection());
            throw ex;
        }
    }

    private List<JiraVersion> getFixVersionIDs(String issueKey) throws SOAPException, IOException {
        JiraIssue issue = this.getIssueByKey(issueKey);
        return issue != null ? issue.getFixVersions() : Collections.emptyList();
    }

    private static void checkSSLException(Exception ex, BugtrackerConnection connection) {
        for (Throwable tempEx = ex; tempEx != null; tempEx = tempEx.getCause()) {
            if (!(tempEx instanceof SSLException)) continue;
            connection.acknowledgeSSLClientCertificate(false);
        }
    }

    private static String extractText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        Node firstChild = node.getFirstChild();
        return firstChild != null ? firstChild.getNodeValue() : null;
    }

    private static Node getUniqueChild(Node parent, String name, SOAPBody body) throws SOAPException {
        List<Node> children = JiraSoapClient.getChildren(parent, name, body);
        if (children.isEmpty()) {
            throw new SOAPException("'" + name + "' not found in element " + parent);
        }
        if (children.size() >= 2) {
            throw new SOAPException("'" + name + "' found multiple times in element " + parent);
        }
        return children.get(0);
    }

    private static List<Node> getChildren(Node parent, String name, SOAPBody body) throws SOAPException {
        NodeList childNodes = parent.getChildNodes();
        ArrayList<Node> rawFoundNodes = new ArrayList<Node>();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            String nodeName = node.getLocalName();
            if (SOAP_FAULT.equals(nodeName)) {
                throw new SOAPException(JiraSoapClient.extractError(node));
            }
            if (!nodeName.equals(name)) continue;
            rawFoundNodes.add(node);
        }
        ArrayList<Node> foundNodes = new ArrayList<Node>();
        for (Node node : rawFoundNodes) {
            if (node.getAttributes().getNamedItem(SOAP_ENC_ARRAYTYPE) != null) {
                NodeList children = node.getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    foundNodes.add(children.item(index));
                }
                continue;
            }
            foundNodes.add(node);
        }
        ArrayList<Node> resolvedNodes = new ArrayList<Node>();
        for (Node node : foundNodes) {
            resolvedNodes.add(JiraSoapClient.resolveHref(node, body));
        }
        return resolvedNodes;
    }

    private static Node resolveHref(Node node, SOAPBody body) throws SOAPException {
        Node href = node.getAttributes().getNamedItem(SOAP_HREF);
        if (href == null) {
            return node;
        }
        String hrefId = JiraSoapClient.extractText(href);
        if (hrefId.startsWith("#")) {
            hrefId = hrefId.substring(1);
        }
        Iterator it = body.getChildElements();
        while (it.hasNext()) {
            Node idAttribute;
            Node child = (Node)it.next();
            if (!SOAP_MULTIREF.equals(child.getNodeName()) || (idAttribute = child.getAttributes().getNamedItem(SOAP_ID)) == null || !JiraSoapClient.extractText(idAttribute).equals(hrefId)) continue;
            return child;
        }
        throw new SOAPException("multiref with ID '" + hrefId + "' not found in body.");
    }

    private static void addString(SOAPElement parent, String key, String value, SOAPFactory soapFactory) throws SOAPException {
        parent.addChildElement(soapFactory.createName(key)).addTextNode(value).setAttribute(XSI_TYPE, XSD_STRING);
    }

    private static SOAPElement addElement(SOAPElement parent, String key, String type, SOAPFactory soapFactory) throws SOAPException {
        SOAPElement element = parent.addChildElement(soapFactory.createName(key));
        element.addAttribute(soapFactory.createName(XSI_TYPE), "ns2:" + type);
        return element;
    }

    private static SOAPElement addArray(SOAPElement bodyElement, String key, SOAPFactory soapFactory) throws SOAPException {
        SOAPElement array = bodyElement.addChildElement(soapFactory.createName(key));
        array.addAttribute(soapFactory.createName(XSI_TYPE), SOAP_ENC_ARRAY);
        array.addAttribute(soapFactory.createName("xmlns:ns2"), "http://beans.soap.rpc.jira.atlassian.com");
        return array;
    }

    private static SOAPBodyElement createBody(String command, SOAPMessage request, SOAPFactory soapFactory) throws SOAPException {
        Name bodyName = soapFactory.createName(command, "ns1", "http://soap.rpc.jira.atlassian.com");
        return request.getSOAPBody().addBodyElement(bodyName);
    }

    private static SOAPMessage createMessage(MessageFactory messageFactory) throws SOAPException {
        SOAPMessage request = messageFactory.createMessage();
        MimeHeaders mimeHeaders = request.getMimeHeaders();
        mimeHeaders.addHeader("SOAPAction", "");
        request.getSOAPHeader().detachNode();
        request.getSOAPBody().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return request;
    }

    private static String extractError(Node node) {
        String error = JiraSoapClient.extractRawError(node);
        if (error == null) {
            return "Unknown error";
        }
        error = error.trim();
        String REMOTE_EXCEPTION = "com.atlassian.jira.rpc.exception.RemoteException:";
        if (error.startsWith("com.atlassian.jira.rpc.exception.RemoteException:")) {
            error = error.substring("com.atlassian.jira.rpc.exception.RemoteException:".length());
        }
        return error.trim();
    }

    private static String extractRawError(Node node) {
        if (node.getNodeType() == 3) {
            return JiraSoapClient.extractText(node);
        }
        NodeList children = node.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (!child.getLocalName().equals(SOAP_FAULTSTRING)) continue;
            return JiraSoapClient.extractText(child);
        }
        return JiraSoapClient.extractText(node);
    }
}

