/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.jira.JiraPlugin;
import com.syntevo.plugin.jira.transport.JiraClient;
import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraIssueStatus;
import com.syntevo.plugin.jira.transport.JiraIssueXmlHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JiraQueryClient
extends JiraClient {
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private int currentIndex;
    private String queryUrl;

    public JiraQueryClient(BugtrackerConnection connection) {
        super(connection);
    }

    public List<JiraIssue> getFirstIssues(String projectId, String assignee, List<JiraIssueStatus> stati, List<String> fixVersions, int count) throws IOException {
        BugtrackerConnection connection = this.getBugtrackerConnection();
        this.queryUrl = JiraQueryClient.createQueryUrl(connection.getUrl(), connection.getUsername(), connection.getPassword(), projectId, assignee, fixVersions, stati);
        this.currentIndex = 0;
        return this.getNextIssues(count);
    }

    public List<JiraIssue> getNextIssues(int count) throws IOException {
        URL url = JiraQueryClient.createUrl(this.queryUrl, this.currentIndex, count);
        this.currentIndex += count;
        return this.readIssues(url);
    }

    private List<JiraIssue> readIssues(URL url) throws IOException {
        url = this.createConnectableURL(url);
        JiraPlugin.LOGGER.debug("Sending request: " + url);
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            JiraIssueXmlHandler handler = new JiraIssueXmlHandler();
            parser.parse(url.openStream(), (DefaultHandler)handler);
            this.getBugtrackerConnection().acknowledgeSSLClientCertificate(true);
            return handler.getIssues();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (SSLException ex) {
            this.getBugtrackerConnection().acknowledgeSSLClientCertificate(false);
            throw ex;
        }
    }

    private static String createQueryUrl(String baseUrl, String username, String password, String projectId, String assignee, List<String> fixVersions, List<JiraIssueStatus> stati) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(baseUrl);
        builder.append("sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC");
        builder.append("&os_username=");
        builder.append(URLEncoder.encode(username, "UTF-8"));
        builder.append("&os_password=");
        builder.append(URLEncoder.encode(password, "UTF-8"));
        builder.append("&pid=");
        builder.append(projectId);
        if (assignee != null) {
            builder.append("&assigneeSelect=specificuser&assignee=");
            builder.append(URLEncoder.encode(assignee, "UTF-8"));
        }
        for (JiraIssueStatus status : stati) {
            if (status.getJiraId() == null) continue;
            builder.append("&status=");
            builder.append(status.getJiraId());
        }
        for (String fixVersion : fixVersions) {
            builder.append("&fixfor=");
            builder.append(URLEncoder.encode(fixVersion, "UTF-8"));
        }
        return builder.toString();
    }

    private static URL createUrl(String queryUrl, int currentIndex, int count) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        builder.append(queryUrl);
        builder.append("&tempMax=");
        builder.append(count);
        builder.append("&pager/start=");
        builder.append(currentIndex);
        return new URL(builder.toString());
    }
}

