/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class JiraIssueType {
    public static final JiraIssueType BUG = new JiraIssueType("bug", "1");
    public static final JiraIssueType NEW_FEATURE = new JiraIssueType("new-feature", "2");
    public static final JiraIssueType TASK = new JiraIssueType("task", "3");
    public static final JiraIssueType IMPROVEMENT = new JiraIssueType("improvement", "4");
    public static final JiraIssueType UNKNOWN = new JiraIssueType("unknown", null);
    public static final List<JiraIssueType> ALL = Collections.unmodifiableList(Arrays.asList(BUG, NEW_FEATURE, TASK, IMPROVEMENT, UNKNOWN));
    private final String id;
    private final String jiraId;

    public static JiraIssueType parseFromId(String id) {
        for (JiraIssueType type : ALL) {
            if (type.jiraId == null || !type.jiraId.equals(id)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public JiraIssueType(String id, String jiraId) {
        this.id = id;
        this.jiraId = jiraId;
    }

    public String toString() {
        return this.id;
    }
}

