/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class JiraIssueResolution {
    public static final JiraIssueResolution FIXED = new JiraIssueResolution("fixed", "1");
    public static final JiraIssueResolution WONT_FIX = new JiraIssueResolution("wont-fix", "2");
    public static final JiraIssueResolution INCOMPLETE = new JiraIssueResolution("incomplete", "3");
    public static final JiraIssueResolution DUPLICATE = new JiraIssueResolution("duplicate", "4");
    public static final JiraIssueResolution CANNOT_REPRODUCE = new JiraIssueResolution("cannot-reproduce", "5");
    public static final JiraIssueResolution UNKNOWN = new JiraIssueResolution("unknown", null);
    public static final List<JiraIssueResolution> ALL = Collections.unmodifiableList(Arrays.asList(FIXED, WONT_FIX, INCOMPLETE, DUPLICATE, CANNOT_REPRODUCE, UNKNOWN));
    private final String id;
    private final String jiraId;

    public static JiraIssueResolution parseFromId(String id) {
        for (JiraIssueResolution resolution : ALL) {
            if (resolution.jiraId == null || !resolution.jiraId.equals(id)) continue;
            return resolution;
        }
        return UNKNOWN;
    }

    public JiraIssueResolution(String id, String jiraId) {
        this.id = id;
        this.jiraId = jiraId;
    }

    public String toString() {
        return this.id;
    }

    public String getJiraId() {
        return this.jiraId;
    }
}

