/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.smartsvn.command.SvnClients;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterPostCommandPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPostCommandPhase;
import com.syntevo.openapi.deprecated.smartsvn.file.Path;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.jira.JiraPlugin;
import com.syntevo.plugin.jira.commit.workflow.JiraResolvePacket;
import com.syntevo.plugin.jira.transport.JiraIssueResolution;
import com.syntevo.plugin.jira.transport.JiraSoapClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.SubversionException;
import org.jetbrains.annotations.NotNull;

final class JiraPostCommandPhase
extends FilterPostCommandPhase {
    private final List<JiraResolvePacket> resolvePackets;
    private final DialogDisplayer dialogDisplayer;

    public JiraPostCommandPhase(ICommitPostCommandPhase wrappedPhase, List<JiraResolvePacket> resolvePackets, DialogDisplayer dialogDisplayer) {
        super(wrappedPhase);
        this.resolvePackets = resolvePackets;
        this.dialogDisplayer = dialogDisplayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(@NotNull Map<Path, ClientNotifyInformation> pathToClientNotifyInformation, @NotNull SvnClients svnClients) throws SubversionException {
        super.process(pathToClientNotifyInformation, svnClients);
        JiraPlugin.LOGGER.debug("Resolving packets");
        for (JiraResolvePacket resolvePacket : this.resolvePackets) {
            JiraPlugin.LOGGER.info("Resolving " + resolvePacket);
            BugtrackerConnection connection = resolvePacket.getConnection();
            String issueKey = resolvePacket.getIssueKey();
            JiraSoapClient soapClient = new JiraSoapClient(connection);
            try {
                if (!soapClient.login()) {
                    JiraPlugin.LOGGER.warn("JIRA login failed, can resolveIssue " + resolvePacket);
                    return;
                }
                try {
                    soapClient.resolve(issueKey, connection.getUsername(), JiraIssueResolution.FIXED, resolvePacket.getFixVersion());
                    JiraPlugin.LOGGER.warn(" ... resolved");
                }
                finally {
                    soapClient.logout();
                }
            }
            catch (IOException ex) {
                JiraPlugin.LOGGER.error(ex.getMessage(), (Throwable)ex);
                this.dialogDisplayer.showErrorDialogSync("JIRA", ex.getMessage(), null);
            }
            catch (SOAPException ex) {
                String message = ex.getMessage();
                int index = message.indexOf("\n");
                if (index > 0) {
                    message = message.substring(0, index).trim();
                }
                JiraPlugin.LOGGER.error(message, (Throwable)ex);
                this.dialogDisplayer.showErrorDialogSync("JIRA", message, null);
            }
        }
    }
}

