/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogFactory;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitBugtraqProperties;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitPacket;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitPacketPhaseState;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterCommitPacketPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPacketPhase;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.openapi.deprecated.smartsvn.thread.IJob;
import com.syntevo.openapi.deprecated.smartsvn.thread.IJobSuccessRunnable;
import com.syntevo.openapi.deprecated.smartsvn.thread.JobExecutor;
import com.syntevo.openapi.deprecated.smartsvn.thread.ProgressViewer;
import com.syntevo.openapi.deprecated.util.UiUtils;
import com.syntevo.plugin.jira.JiraPlugin;
import com.syntevo.plugin.jira.commit.JiraUIConnection;
import com.syntevo.plugin.jira.commit.JiraUrl;
import com.syntevo.plugin.jira.commit.workflow.JiraResolvablePacket;
import com.syntevo.plugin.jira.commit.workflow.JiraResolveIssueDialog;
import com.syntevo.plugin.jira.commit.workflow.JiraResolvePacket;
import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraIssueStatus;
import com.syntevo.plugin.jira.transport.JiraSoapClient;
import com.syntevo.plugin.jira.transport.JiraVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.soap.SOAPException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JiraFilesPhase
extends FilterCommitPacketPhase {
    private static final boolean RESOLVE_ENABLED = "true".equals(System.getProperty("smartsvn.plugin.jira.show-resolveIssue-dialog", "true"));
    private final SettingsServices settingsServices;
    private final JobExecutor jobExecutor;
    private final DialogDisplayer dialogDisplayer;
    private final GuiSpacings spacings;
    private List<JiraResolvePacket> selectedResolvePackets;

    public JiraFilesPhase(ICommitPacketPhase internalPhase, SettingsServices settingsServices, JobExecutor jobExecutor, GuiSpacings spacings, DialogDisplayer dialogDisplayer) {
        super(internalPhase);
        this.settingsServices = settingsServices;
        this.jobExecutor = jobExecutor;
        this.dialogDisplayer = dialogDisplayer;
        this.spacings = spacings;
    }

    public void updateTo(final @NotNull CommitPacketPhaseState state, final @NotNull Runnable successRunnable) {
        super.updateTo(state, new Runnable(){

            @Override
            public void run() {
                JiraFilesPhase.this.selectedResolvePackets = null;
                if (!RESOLVE_ENABLED) {
                    successRunnable.run();
                    return;
                }
                HashSet allResolvablePackets = new HashSet();
                for (CommitPacket packet : new ArrayList(state.getPackets())) {
                    allResolvablePackets.addAll(JiraFilesPhase.extractResolvablePackets(packet, JiraFilesPhase.this.settingsServices, JiraFilesPhase.this.spacings, JiraFilesPhase.this.dialogDisplayer));
                }
                if (allResolvablePackets.isEmpty()) {
                    successRunnable.run();
                    return;
                }
                JiraFilesPhase.this.processResolvablePackets(allResolvablePackets, JiraFilesPhase.this.jobExecutor, successRunnable, JiraFilesPhase.this.dialogDisplayer);
            }
        });
    }

    @Nullable
    public List<JiraResolvePacket> getResolvePackets() {
        UiUtils.assertThreadAccess();
        return this.selectedResolvePackets != null ? Collections.unmodifiableList(this.selectedResolvePackets) : null;
    }

    private void processResolvablePackets(Set<JiraResolvablePacket> allResolvablePackets, JobExecutor jobExecutor, final @NotNull Runnable successRunnable, final DialogDisplayer dialogDisplayer) {
        JiraPlugin.LOGGER.debug("Filtering resolvable packets");
        final ArrayList<JiraResolvablePacket> resolvablePacketsInOrder = new ArrayList<JiraResolvablePacket>(allResolvablePackets);
        Collections.sort(resolvablePacketsInOrder, new Comparator<JiraResolvablePacket>(){

            @Override
            public int compare(JiraResolvablePacket o1, JiraResolvablePacket o2) {
                return o1.getIssueKey().compareTo(o2.getIssueKey());
            }
        });
        jobExecutor.executeAsync("JIRA", new IJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IJobSuccessRunnable execute(@NotNull ProgressViewer progressViewer) {
                int progress = 0;
                ArrayList<JiraResolvablePacket> resolvablePackets = new ArrayList<JiraResolvablePacket>();
                for (JiraResolvablePacket packet : resolvablePacketsInOrder) {
                    progressViewer.setMessage("Querying " + packet.getConnection().getUrl());
                    progressViewer.setProgress(progress++, resolvablePacketsInOrder.size());
                    JiraSoapClient client = new JiraSoapClient(packet.getConnection());
                    try {
                        if (!client.login()) {
                            JiraPlugin.LOGGER.warn("JIRA login failed, can't check " + packet);
                            continue;
                        }
                        try {
                            JiraIssue issue = client.getIssueByKey(packet.getIssueKey());
                            if (!JiraFilesPhase.isResolvable(issue)) {
                                JiraPlugin.LOGGER.debug(" ... " + packet + " not resolvable (status=" + issue.getStatus() + ")");
                                continue;
                            }
                            List<JiraVersion> unreleasedVersions = client.getUnreleasedVersionsByProjectKeyInOrder(packet.getProjectKey());
                            packet.setIssue(issue);
                            packet.setUnreleasedVersions(unreleasedVersions);
                            resolvablePackets.add(packet);
                            JiraPlugin.LOGGER.debug(" ... " + packet + " is resolvable.");
                        }
                        finally {
                            client.logout();
                        }
                    }
                    catch (IOException | SOAPException ex) {
                        JiraPlugin.LOGGER.error(ex.getMessage(), ex);
                        dialogDisplayer.showErrorDialogSync("JIRA", ex.getMessage(), null);
                    }
                }
                JiraFilesPhase.this.selectedResolvePackets = JiraFilesPhase.this.chooseResolvePackets(resolvablePackets);
                return new IJobSuccessRunnable(){

                    public void runInEdt(@NotNull DialogDisplayer dialogDisplayer) {
                        if (JiraFilesPhase.this.selectedResolvePackets != null) {
                            successRunnable.run();
                        }
                    }
                };
            }
        });
    }

    @Nullable
    private List<JiraResolvePacket> chooseResolvePackets(List<JiraResolvablePacket> resolvablePackets) {
        ArrayList<JiraResolvePacket> selectedResolvePackets = new ArrayList<JiraResolvePacket>();
        for (final JiraResolvablePacket packet : resolvablePackets) {
            final List<JiraVersion> unreleasedVersions = packet.getUnreleasedVersions();
            if (unreleasedVersions == null || unreleasedVersions.isEmpty()) {
                JiraPlugin.LOGGER.debug(" ... " + packet + " has no unreleased versions");
                continue;
            }
            JiraResolveIssueDialog resolveIssueDialog = (JiraResolveIssueDialog)this.dialogDisplayer.showSync((IDialogFactory)new IDialogFactory<JiraResolveIssueDialog>(){

                @NotNull
                public JiraResolveIssueDialog createDialog() {
                    return JiraResolveIssueDialog.createInstance(unreleasedVersions, packet, JiraFilesPhase.this.spacings);
                }
            });
            if (resolveIssueDialog == null) {
                JiraPlugin.LOGGER.debug(" ... " + packet + " cancelled");
                return null;
            }
            JiraVersion fixVersion = resolveIssueDialog.getFixVersion();
            if (fixVersion == null) {
                JiraPlugin.LOGGER.debug(" ... " + packet + " not selected");
                continue;
            }
            JiraPlugin.LOGGER.debug(" ... " + packet + " selected");
            selectedResolvePackets.add(new JiraResolvePacket(packet.getConnection(), packet.getIssueKey(), fixVersion));
        }
        return selectedResolvePackets;
    }

    private static boolean isResolvable(JiraIssue issue) {
        JiraIssueStatus status = issue.getStatus();
        return status == JiraIssueStatus.IN_PROGRESS || status == JiraIssueStatus.OPEN || status == JiraIssueStatus.REOPENED;
    }

    private static Collection<JiraResolvablePacket> extractResolvablePackets(CommitPacket packet, SettingsServices settingsServices, GuiSpacings spacings, DialogDisplayer dialogDisplayer) {
        JiraPlugin.LOGGER.debug("Extracting resolvable packets for " + packet.getCommitRoot());
        CommitBugtraqProperties bugtraqProperties = packet.getBugtraqProperties();
        if (bugtraqProperties == null) {
            JiraPlugin.LOGGER.debug(" ... no bugtraq-properties");
            return Collections.emptyList();
        }
        JiraUrl url = JiraUrl.parseFromBugtraqUrls(bugtraqProperties.getURL());
        if (url == null) {
            JiraPlugin.LOGGER.debug(" ... no bugtraq URL");
            return Collections.emptyList();
        }
        JiraPlugin.LOGGER.debug(" ... URL is " + url);
        String message = packet.getMessage();
        String projectKey = url.getProjectKey();
        JiraPlugin.LOGGER.debug(" ... projectKey is " + projectKey);
        ArrayList<JiraResolvablePacket> resolvePackets = new ArrayList<JiraResolvablePacket>();
        JiraUIConnection connection = new JiraUIConnection(url.getBaseUrl(), settingsServices, true, spacings, dialogDisplayer);
        JiraPlugin.LOGGER.debug("Parsing message '" + message + "'");
        if (message != null) {
            int index = message.indexOf(projectKey);
            while (index != -1) {
                String issueID = JiraFilesPhase.extractIssueID(message, projectKey, index);
                if (issueID == null) {
                    ++index;
                } else {
                    JiraPlugin.LOGGER.debug(" ... found issue " + issueID);
                    resolvePackets.add(new JiraResolvablePacket(issueID, projectKey, connection));
                    index += issueID.length();
                }
                index = message.indexOf(projectKey, index + 1);
            }
        }
        return resolvePackets;
    }

    private static boolean isIssueIDCharacter(char ch) {
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == '-';
    }

    @Nullable
    private static String extractIssueID(String message, String projectKey, int startIndex) {
        int index;
        if (startIndex > 0 && JiraFilesPhase.isIssueIDCharacter(message.charAt(startIndex - 1))) {
            return null;
        }
        int dashIndex = startIndex + projectKey.length();
        if (message.length() <= dashIndex || message.charAt(dashIndex) != '-') {
            return null;
        }
        for (index = dashIndex + 1; index < message.length() && Character.isDigit(message.charAt(index)); ++index) {
        }
        if (index < message.length() && JiraFilesPhase.isIssueIDCharacter(message.charAt(index))) {
            return null;
        }
        return message.substring(startIndex, index);
    }
}

