/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.plugin.jira.commit.messagesource.JiraIssueList;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueTable;
import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraIssueStatus;
import com.syntevo.plugin.jira.transport.JiraQueryClient;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class JiraIssueLoaderTableUpdater {
    private final JiraQueryClient client;
    private final JiraIssueList issueList;
    private final JiraIssueTable table;
    private boolean aborted;

    public JiraIssueLoaderTableUpdater(JiraQueryClient client, JiraIssueList issueList, JiraIssueTable table) {
        this.client = client;
        this.issueList = issueList;
        this.table = table;
    }

    public void load(String projectId, @Nullable String assignee, List<JiraIssueStatus> stati, List<String> fixVersions, int relevance) throws IOException {
        boolean start = true;
        while (!this.aborted) {
            List<JiraIssue> fetchedIssues;
            if (start) {
                start = false;
                fetchedIssues = this.client.getFirstIssues(projectId, assignee, stati, fixVersions, 100);
            } else {
                fetchedIssues = this.client.getNextIssues(100);
            }
            this.issueList.addIssues(fetchedIssues, relevance);
            this.table.setIssues(this.issueList.getIssuesInOrder());
            if (!fetchedIssues.isEmpty()) continue;
            return;
        }
    }

    public void abort() {
        this.aborted = true;
    }
}

