/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.plugin.jira.commit.messagesource.JiraIssueByRelevanceComparator;
import com.syntevo.plugin.jira.transport.JiraIssue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class JiraIssueList {
    private final Map<String, JiraIssue> idToIssue = new HashMap<String, JiraIssue>();
    private final Map<JiraIssue, Integer> issueToRelevance = new HashMap<JiraIssue, Integer>();
    private List<JiraIssue> issuesInOrder = new ArrayList<JiraIssue>();

    public synchronized void addIssues(List<JiraIssue> issues, int relevance) {
        for (JiraIssue issue : issues) {
            String id = issue.getId();
            JiraIssue existingIssue = this.idToIssue.get(id);
            Integer existingRelevance = this.issueToRelevance.get(existingIssue);
            if (existingRelevance != null && existingRelevance <= relevance) continue;
            this.idToIssue.put(id, issue);
            this.issueToRelevance.put(issue, new Integer(relevance));
            this.issuesInOrder = null;
        }
    }

    public synchronized List<JiraIssue> getIssuesInOrder() {
        this.issuesInOrder = new ArrayList<JiraIssue>(this.idToIssue.values());
        Collections.sort(this.issuesInOrder, new JiraIssueByRelevanceComparator(this.issueToRelevance));
        return this.issuesInOrder;
    }

    public synchronized void clear() {
        this.idToIssue.clear();
        this.issueToRelevance.clear();
        this.issuesInOrder = null;
    }
}

