/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.plugin.jira.transport.JiraIssue;
import java.util.Comparator;
import java.util.Map;

final class JiraIssueByRelevanceComparator
implements Comparator<JiraIssue> {
    private final Map<JiraIssue, Integer> issueToRelevance;

    public JiraIssueByRelevanceComparator(Map<JiraIssue, Integer> issueToRelevance) {
        this.issueToRelevance = issueToRelevance;
    }

    @Override
    public int compare(JiraIssue o1, JiraIssue o2) {
        int relevanceComparison = this.issueToRelevance.get(o1).compareTo(this.issueToRelevance.get(o2));
        if (relevanceComparison != 0) {
            return relevanceComparison;
        }
        return -JiraIssueByRelevanceComparator.compareID(o1.getId(), o2.getId());
    }

    private static int compareID(String id1, String id2) {
        Integer id2o;
        Integer id1o;
        try {
            id1o = new Integer(id1);
        }
        catch (NumberFormatException e) {
            id1o = new Integer(0);
        }
        try {
            id2o = new Integer(id2);
        }
        catch (NumberFormatException e) {
            id2o = new Integer(0);
        }
        return id1o.compareTo(id2o);
    }
}

