/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogFactory;
import com.syntevo.openapi.deprecated.smartsvn.settings.Settings;
import com.syntevo.plugin.common.bugtracker.commit.BugtrackerClientCertificateDialog;
import com.syntevo.plugin.common.bugtracker.commit.BugtrackerCredentialsDialog;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerHttpsClientCertificate;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BugtrackerUIConnection
implements BugtrackerConnection {
    private static final Map<String, String> volatileSettings = new HashMap<String, String>();
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_CLIENT_CERTIFICATE = "client-certificate";
    private static final String KEY_CLIENT_CERTIFICATE_PASSPHRASE = "client-certificate-passphrase";
    private static final String KEY_SERVER_SHA_FINGERPRINT = "server-sha-fingerprint";
    private static PrintWriter log;
    private final String url;
    private final String pluginName;
    private final Settings pluginSettings;
    private final File settingsFile;
    private final boolean debugLogging;
    private final String credentialsDialogTitle;
    private final String certificateDialogTitle;
    private final DialogDisplayer dialogDisplayer;
    private final boolean silent;
    private final GuiSpacings spacings;

    public BugtrackerUIConnection(@NotNull String url, @NotNull String pluginName, @NotNull Settings pluginSettings, @NotNull File settingsFile, boolean silent, boolean debugLogging, @NotNull String credentialsDialogTitle, @NotNull String certificateDialogTitle, @NotNull GuiSpacings spacings, @NotNull DialogDisplayer dialogDisplayer) {
        this.pluginName = pluginName;
        this.pluginSettings = pluginSettings;
        this.settingsFile = settingsFile;
        this.debugLogging = debugLogging;
        this.credentialsDialogTitle = credentialsDialogTitle;
        this.certificateDialogTitle = certificateDialogTitle;
        this.dialogDisplayer = dialogDisplayer;
        this.silent = silent;
        this.url = url;
        this.spacings = spacings;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public String getUsername() {
        if (!this.checkCredentials()) {
            return null;
        }
        return this.retrieveValue(this.url, KEY_USERNAME);
    }

    @Override
    @Nullable
    public String getPassword() {
        if (!this.checkCredentials()) {
            return null;
        }
        return this.retrievePassword(this.url, KEY_PASSWORD);
    }

    @Override
    public void acknowledgeCredentials(boolean success) {
        String username = success ? this.retrieveValue(this.url, KEY_USERNAME) : null;
        String password = success ? this.retrievePassword(this.url, KEY_PASSWORD) : null;
        this.storeValue(this.url, KEY_USERNAME, username, Boolean.TRUE);
        this.storePassword(this.url, KEY_PASSWORD, password, password == null ? Boolean.FALSE : null);
    }

    @Override
    public boolean checkSSLServerFingerprintTrusted(@NotNull String fingerprintSHA, @NotNull String fingerprintMD5, @NotNull String url) {
        String fingerprint = this.retrieveValue(this.url, KEY_SERVER_SHA_FINGERPRINT);
        if (fingerprint == null ? this.silent || !this.dialogDisplayer.showConfirmationDialogSync(this.pluginName, "Please verify the SSL certificate for " + url, "The fingerprints are:\nSHA: " + fingerprintSHA + "\nMD5: " + fingerprintMD5, "Confirm", false) : !fingerprint.equals(fingerprintSHA) && (this.silent || !this.dialogDisplayer.showConfirmationDialogSync(this.pluginName, "The SSL certificate for " + url + " has changed.", "If you are not sure whether this is OK, please contact the server administrator. The fingerprints are:\nSHA: " + fingerprintSHA + "\nMD5: " + fingerprintMD5, "Confirm", false))) {
            return false;
        }
        this.storeValue(this.url, KEY_SERVER_SHA_FINGERPRINT, fingerprintSHA, Boolean.TRUE);
        return true;
    }

    @Override
    @Nullable
    public BugtrackerHttpsClientCertificate getSSLClientCertificate(@Nullable String location) {
        if (!this.checkSSLCredentials()) {
            return null;
        }
        String certificate = this.retrieveValue(this.url, KEY_CLIENT_CERTIFICATE);
        String certificatePassword = this.retrievePassword(this.url, KEY_CLIENT_CERTIFICATE_PASSPHRASE);
        return new BugtrackerHttpsClientCertificate(new File(certificate), certificatePassword);
    }

    @Override
    public void showError(@NotNull String message, @NotNull Throwable ex) {
        if (this.silent) {
            return;
        }
        this.dialogDisplayer.showErrorDialogSync(this.pluginName, message, ex.getMessage());
    }

    @Override
    public void acknowledgeSSLClientCertificate(boolean success) {
        String certificate = success ? this.retrieveValue(this.url, KEY_CLIENT_CERTIFICATE) : null;
        String certificatePassword = success ? this.retrievePassword(this.url, KEY_CLIENT_CERTIFICATE_PASSPHRASE) : null;
        this.storeValue(this.url, KEY_CLIENT_CERTIFICATE, certificate, Boolean.TRUE);
        this.storePassword(this.url, KEY_CLIENT_CERTIFICATE_PASSPHRASE, certificatePassword, certificatePassword == null ? Boolean.FALSE : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PrintWriter getLog() throws IOException {
        Class<BugtrackerUIConnection> clazz = BugtrackerUIConnection.class;
        synchronized (BugtrackerUIConnection.class) {
            if (!this.debugLogging) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            if (log != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return log;
            }
            log = new PrintWriter(new FileWriter(this.settingsFile));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return log;
        }
    }

    protected void storeValue(@NotNull String baseUrl, @NotNull String key, @Nullable String value, @Nullable Boolean permanentNotTemporary) {
        key = baseUrl + "-" + key;
        volatileSettings.put(key, value);
        if (permanentNotTemporary != null) {
            if (permanentNotTemporary.booleanValue()) {
                this.pluginSettings.putString(key, value);
            } else {
                this.pluginSettings.removeValue(key);
            }
        }
    }

    protected void storePassword(@NotNull String baseUrl, @NotNull String key, @Nullable String password, @Nullable Boolean permanentNotTemporary) {
        key = baseUrl + "-" + key;
        volatileSettings.put(key, password);
        if (permanentNotTemporary != null) {
            if (permanentNotTemporary.booleanValue()) {
                this.pluginSettings.putPassword(key, password, this.dialogDisplayer);
            } else {
                this.pluginSettings.removeValue(key);
            }
        }
    }

    @Nullable
    protected String retrieveValue(@NotNull String baseUrl, @NotNull String key) {
        key = baseUrl + "-" + key;
        String value = volatileSettings.get(key);
        if (value != null) {
            return value;
        }
        value = this.pluginSettings.getString(key, null);
        if (value != null) {
            volatileSettings.put(key, value);
        }
        return value;
    }

    @Nullable
    protected String retrievePassword(@NotNull String baseUrl, @NotNull String key) {
        key = baseUrl + "-" + key;
        String value = volatileSettings.get(key);
        if (value != null) {
            return value;
        }
        value = this.pluginSettings.getPassword(key, this.dialogDisplayer);
        if (value != null) {
            volatileSettings.put(key, value);
        }
        return value;
    }

    private boolean checkCredentials() {
        final String username = this.retrieveValue(this.url, KEY_USERNAME);
        final String password = this.retrievePassword(this.url, KEY_PASSWORD);
        if (username != null && password != null) {
            return true;
        }
        if (this.silent) {
            return false;
        }
        BugtrackerCredentialsDialog dialog = (BugtrackerCredentialsDialog)this.dialogDisplayer.showSync((IDialogFactory)new IDialogFactory<BugtrackerCredentialsDialog>(){

            @NotNull
            public BugtrackerCredentialsDialog createDialog() {
                return new BugtrackerCredentialsDialog(BugtrackerUIConnection.this.credentialsDialogTitle, username, password, password != null, BugtrackerUIConnection.this.spacings);
            }
        });
        if (dialog == null) {
            return false;
        }
        Boolean storePassword = dialog.isStorePassword();
        this.storeValue(this.url, KEY_USERNAME, dialog.getUsername(), storePassword);
        this.storePassword(this.url, KEY_PASSWORD, dialog.getPassword(), storePassword);
        return true;
    }

    private boolean checkSSLCredentials() {
        final String clientCertificate = this.retrieveValue(this.url, KEY_CLIENT_CERTIFICATE);
        final String clientCertificatePassword = this.retrievePassword(this.url, KEY_CLIENT_CERTIFICATE_PASSPHRASE);
        if (clientCertificate != null && clientCertificatePassword != null) {
            return true;
        }
        if (this.silent) {
            return false;
        }
        BugtrackerClientCertificateDialog dialog = (BugtrackerClientCertificateDialog)this.dialogDisplayer.showSync((IDialogFactory)new IDialogFactory<BugtrackerClientCertificateDialog>(){

            @NotNull
            public BugtrackerClientCertificateDialog createDialog() {
                return new BugtrackerClientCertificateDialog(BugtrackerUIConnection.this.certificateDialogTitle, clientCertificate != null ? new File(clientCertificate) : null, clientCertificatePassword, clientCertificatePassword != null, BugtrackerUIConnection.this.spacings);
            }
        });
        if (dialog == null) {
            return false;
        }
        Boolean storePassphrase = dialog.isStorePassphrase();
        File cert = dialog.getCertificate();
        this.storeValue(this.url, KEY_CLIENT_CERTIFICATE, cert != null ? cert.getAbsolutePath() : null, storePassphrase);
        this.storePassword(this.url, KEY_CLIENT_CERTIFICATE_PASSPHRASE, dialog.getPassphrase(), storePassphrase);
        return true;
    }
}

