/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import sun.security.validator.ValidatorException;

public final class BugtrackerHttpsTrustManager
implements X509TrustManager {
    private final BugtrackerConnection connection;

    public BugtrackerHttpsTrustManager(@NotNull BugtrackerConnection connection) {
        this.connection = connection;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String string) throws CertificateException {
        if (certificates.length == 0) {
            throw new ValidatorException("Can't trust empty certificate list.");
        }
        if (!this.connection.checkSSLServerFingerprintTrusted(BugtrackerHttpsTrustManager.getFingerprint(certificates[0], "SHA"), BugtrackerHttpsTrustManager.getFingerprint(certificates[0], "MD5"), this.connection.getUrl())) {
            throw new ValidatorException("Server not trusted.");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private static String getFingerprint(@NotNull X509Certificate certificate, @NotNull String algorithm) throws CertificateException {
        MessageDigest messagedigest;
        byte[] encodedBytes = certificate.getEncoded();
        try {
            messagedigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertificateException("Can't create MD5-digest!");
        }
        byte[] digestedBytes = messagedigest.digest(encodedBytes);
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < digestedBytes.length; ++index) {
            BugtrackerHttpsTrustManager.byte2hex(digestedBytes[index], buffer);
            if (index >= digestedBytes.length - 1) continue;
            buffer.append(":");
        }
        return buffer.toString();
    }

    private static void byte2hex(byte b, @NotNull StringBuffer buffer) {
        char[] ac = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = (b & 0xF0) >> 4;
        int j = b & 0xF;
        buffer.append(ac[i]);
        buffer.append(ac[j]);
    }
}

