/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerHttpsClientCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BugtrackerHttpsKeyManager
implements X509KeyManager {
    private final BugtrackerConnection connection;
    private PrivateKey privateKey;
    private Certificate certificate;

    public BugtrackerHttpsKeyManager(@NotNull BugtrackerConnection connection) {
        this.connection = connection;
    }

    @Override
    public String[] getClientAliases(String location, Principal[] principals) {
        return new String[0];
    }

    @Override
    @Nullable
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        if (!this.checkClientCertificate("")) {
            return null;
        }
        return this.certificate.getPublicKey().getAlgorithm();
    }

    @Override
    public String[] getServerAliases(String location, Principal[] principals) {
        return new String[0];
    }

    @Override
    @Nullable
    public String chooseServerAlias(String location, Principal[] principals, Socket socket) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String location) {
        if (!this.checkClientCertificate("")) {
            return new X509Certificate[0];
        }
        return new X509Certificate[]{(X509Certificate)this.certificate};
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey(String location) {
        if (!this.checkClientCertificate("")) {
            return null;
        }
        return this.privateKey;
    }

    private boolean checkClientCertificate(@Nullable String location) {
        if (this.certificate != null && this.privateKey != null) {
            return true;
        }
        BugtrackerHttpsClientCertificate clientCertificate = this.connection.getSSLClientCertificate(location);
        if (clientCertificate == null) {
            return false;
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            String password = clientCertificate.getKeyPassword();
            File keyFile = clientCertificate.getKeyFile();
            char[] passwordChars = password != null ? password.toCharArray() : null;
            try (FileInputStream inputStream = new FileInputStream(keyFile);){
                ks.load(inputStream, passwordChars);
            }
            this.privateKey = (PrivateKey)ks.getKey(ks.aliases().nextElement(), passwordChars);
            this.certificate = ks.getCertificate(ks.aliases().nextElement());
            return true;
        }
        catch (GeneralSecurityException ex) {
            this.connection.showError(ex.getMessage(), ex);
            return false;
        }
        catch (IOException ex) {
            this.connection.showError(ex.getMessage(), ex);
            return false;
        }
    }
}

