/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class BugtrackerDebugLoggingInputStream
extends InputStream {
    private final InputStream in;
    private final OutputStream log;

    public BugtrackerDebugLoggingInputStream(@NotNull InputStream in, @NotNull OutputStream logStream) {
        this.in = in;
        this.log = logStream;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        try {
            if (read >= 0) {
                this.log.write(read & 0xFF);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            try {
                this.log.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            try {
                this.log.write(b, off, read);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return read;
    }
}

