/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerDebugLoggingConnection;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerHttpsKeyManager;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerHttpsTrustManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jetbrains.annotations.NotNull;

public abstract class BugtrackerClient {
    private final BugtrackerConnection bugtrackerConnection;

    public abstract void configureConnection(@NotNull URLConnection var1) throws IOException;

    @NotNull
    public static SSLContext createSSLContext(BugtrackerConnection connection) throws IOException {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            KeyManager[] keyManagers = new KeyManager[]{new BugtrackerHttpsKeyManager(connection)};
            TrustManager[] trustManagers = new TrustManager[]{new BugtrackerHttpsTrustManager(connection)};
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public BugtrackerClient(@NotNull BugtrackerConnection bugtrackerConnection) {
        this.bugtrackerConnection = bugtrackerConnection;
    }

    @NotNull
    public final BugtrackerConnection getBugtrackerConnection() {
        return this.bugtrackerConnection;
    }

    @NotNull
    public final URL createConnectableURL(final @NotNull URL url) throws IOException {
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                URLConnection connection = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile()).openConnection();
                BugtrackerClient.this.configureConnection(connection);
                PrintWriter log = BugtrackerClient.this.bugtrackerConnection.getLog();
                if (log == null) {
                    return connection;
                }
                return new BugtrackerDebugLoggingConnection(u, (HttpURLConnection)connection, log);
            }
        });
    }
}

