/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.commit;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import com.syntevo.openapi.deprecated.util.UiUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BugtrackerCredentialsDialog
extends AbstractOkCancelDialog {
    private final GuiSpacings spacings;
    private Text usernameField;
    private Text passwordField;
    private Button storePasswordCheckBox;
    private final String title;
    private String username;
    private String password;
    private boolean storePassword;

    public BugtrackerCredentialsDialog(@NotNull String title, @Nullable String username, @Nullable String password, boolean storePassword, @NotNull GuiSpacings spacings) {
        this.title = title;
        this.username = username;
        this.password = password;
        this.storePassword = storePassword;
        this.spacings = spacings;
        this.getOkAction().setName("Login");
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public Control createComponent(@NotNull Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = this.spacings.getXRelated();
        layout.verticalSpacing = this.spacings.getYUnrelated();
        panel.setLayout((Layout)layout);
        Label usernameLabel = UiUtils.createLabel((String)"&Username:", (Composite)panel);
        usernameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.usernameField = UiUtils.createTextField((String)this.username, (Composite)panel);
        this.usernameField.setLayoutData((Object)new GridData(4, 4, true, false));
        Label passwordLabel = UiUtils.createLabel((String)"&Password:", (Composite)panel);
        passwordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.passwordField = UiUtils.createPasswordField((this.password != null ? 1 : 0) != 0, (Composite)panel);
        this.passwordField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.storePasswordCheckBox = UiUtils.createCheckBox((String)"&Store password", (Composite)panel);
        this.storePasswordCheckBox.setSelection(this.storePassword);
        this.storePasswordCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        return panel;
    }

    public void ok() throws DialogValidationFailedException {
        String username = this.usernameField.getText();
        if (username.length() == 0) {
            throw new DialogValidationFailedException((Control)this.usernameField, "Please enter a username.", "It is used to log in to the bugtracker server.");
        }
        String password = UiUtils.getPassword((Text)this.passwordField, (String)this.password);
        if (password == null || password.length() == 0) {
            throw new DialogValidationFailedException((Control)this.passwordField, "Please enter a password.", "It is used to log in to the bugtracker server.");
        }
        this.username = username;
        this.password = password;
        this.storePassword = this.storePasswordCheckBox.getSelection();
    }

    public void dialogShowing() {
        super.dialogShowing();
        Text componentToFocus = this.username != null ? this.passwordField : this.usernameField;
        componentToFocus.setFocus();
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean isStorePassword() {
        return this.storePassword;
    }
}

