/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.tagmultiple;

import com.syntevo.openapi.deprecated.smartsvn.command.ISvnCommand;
import com.syntevo.openapi.deprecated.smartsvn.command.SvnClients;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnDirectory;
import com.syntevo.openapi.deprecated.smartsvn.tagbranch.SvnTagBranchLayout;
import com.syntevo.openapi.deprecated.smartsvn.tagbranch.SvnTagBranchLayouts;
import com.syntevo.openapi.deprecated.smartsvn.thread.ProgressViewer;
import com.syntevo.openapi.deprecated.util.PluginException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Revision;

final class TagMultipleProjectRootsSvnCommand
implements ISvnCommand {
    private final String tagName;
    private final Set<? extends SvnDirectory> svnDirectories;
    private final boolean fixExternalsRevisions;
    private final SvnTagBranchLayouts svnTagBranchLayouts;
    private final String commitMessage;

    public TagMultipleProjectRootsSvnCommand(String tagName, Set<? extends SvnDirectory> svnDirectories, boolean fixExternalsRevisions, SvnTagBranchLayouts svnTagBranchLayouts, String commitMessage) {
        this.tagName = tagName;
        this.svnDirectories = svnDirectories;
        this.fixExternalsRevisions = fixExternalsRevisions;
        this.svnTagBranchLayouts = svnTagBranchLayouts;
        this.commitMessage = commitMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(SvnClients svnClients, ProgressViewer progressViewer) throws SubversionException {
        String tagLocation;
        HashMap<SvnDirectory, String> directoryToLayout = new HashMap<SvnDirectory, String>();
        for (SvnDirectory svnDirectory : this.svnDirectories) {
            SvnTagBranchLayout svnTagBranchLayout = this.svnTagBranchLayouts.getTrunkTagBranchLayout(svnDirectory.getURLString());
            if (svnTagBranchLayout == null) {
                throw new PluginException("No tag branch layout found for " + svnDirectory.getPath());
            }
            tagLocation = svnTagBranchLayout.getTagLocation(this.tagName);
            if (tagLocation == null) {
                throw new PluginException("Can't determine tag location for " + svnDirectory.getPath());
            }
            directoryToLayout.put(svnDirectory, tagLocation);
        }
        int ii = 0;
        for (SvnDirectory svnDirectory : this.svnDirectories) {
            tagLocation = (String)directoryToLayout.get(svnDirectory);
            progressViewer.setMessage("Tagging " + svnDirectory.getPath().getFile().getAbsolutePath() + " ...");
            progressViewer.setProgress(ii, this.svnDirectories.size());
            ISVNClient svnClient = svnClients.createClient();
            try {
                CopySource copySource = new CopySource(svnDirectory.getPath().getFile().getAbsolutePath(), Revision.WORKING, Revision.WORKING);
                svnClient.copy(Collections.singletonList(copySource), tagLocation, true, true, false, false, this.fixExternalsRevisions, null, null, svnClients.getCommitMessageCallback(this.commitMessage), null);
            }
            finally {
                svnClient.dispose();
            }
            ++ii;
        }
    }
}

