/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.tagmultiple;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.Nullable;

final class TagMultipleProjectRootsDialog
extends AbstractOkCancelDialog {
    private final List<String> previousTags;
    private final String initialCommitMessage;
    private final GuiSpacings spacings;
    private Combo tagNameComboBox;
    private Button fixExternalsCheckBox;
    private Text commitMessageText;
    private String tagName;
    private boolean fixExternals;
    private String commitMessage;

    public TagMultipleProjectRootsDialog(List<String> previousTags, boolean fixExternals, String initialCommitMessage, GuiSpacings spacings) {
        this.previousTags = previousTags;
        this.fixExternals = fixExternals;
        this.initialCommitMessage = initialCommitMessage;
        this.spacings = spacings;
        this.getOkAction().setName("Add Tag");
    }

    public String getTitle() {
        return "Tag Multiple";
    }

    public Control createComponent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = this.spacings.getXRelated();
        layout.verticalSpacing = this.spacings.getYUnrelated();
        panel.setLayout((Layout)layout);
        Label tagNameLabel = new Label(panel, 0);
        tagNameLabel.setText("&Tag Name:");
        tagNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tagNameComboBox = new Combo(panel, 2048);
        this.tagNameComboBox.setItems(this.previousTags.toArray(new String[this.previousTags.size()]));
        this.tagNameComboBox.select(0);
        this.tagNameComboBox.setLayoutData((Object)new GridData(4, 4, true, false));
        TagMultipleProjectRootsDialog.selectTextIfTabbingToComponent((Control)this.tagNameComboBox);
        Label commitMessageLabel = new Label(panel, 0);
        commitMessageLabel.setText("Commit &Message:");
        commitMessageLabel.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        this.commitMessageText = new Text(panel, 2050);
        if (this.initialCommitMessage != null) {
            this.commitMessageText.setText(this.initialCommitMessage);
        }
        TagMultipleProjectRootsDialog.selectTextIfTabbingToComponent((Control)this.commitMessageText);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumWidth = 300;
        data.minimumHeight = 150;
        this.commitMessageText.setLayoutData((Object)data);
        this.fixExternalsCheckBox = new Button(panel, 32);
        this.fixExternalsCheckBox.setText("&Fix external revisions");
        this.fixExternalsCheckBox.setSelection(this.fixExternals);
        this.fixExternalsCheckBox.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        return panel;
    }

    protected void ok() throws DialogValidationFailedException {
        String text = this.tagNameComboBox.getText();
        String string = this.tagName = text != null && text.trim().length() == 0 ? null : text;
        if (this.tagName == null) {
            throw new DialogValidationFailedException((Control)this.tagNameComboBox, "Please enter a tag name.", "Don't use slashes!");
        }
        this.fixExternals = this.fixExternalsCheckBox.getSelection();
        this.commitMessage = this.commitMessageText.getText();
    }

    @Nullable
    public String getTagName() {
        return this.tagName;
    }

    public boolean isFixExternals() {
        return this.fixExternals;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    private static void selectTextIfTabbingToComponent(final Control control) {
        if (!System.getProperty("os.name").contains("Windows")) {
            return;
        }
        TagMultipleProjectRootsDialog.selectAll(control);
        control.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                TagMultipleProjectRootsDialog.selectAll(control);
            }
        });
    }

    private static void selectAll(Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            text.selectAll();
        } else if (control instanceof Combo) {
            Combo combo = (Combo)control;
            combo.setSelection(new Point(0, combo.getText().length()));
        }
    }
}

