/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.tagmultiple;

import com.syntevo.openapi.deprecated.gui.dialog.AbstractDialog;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogResultHandler;
import com.syntevo.openapi.deprecated.smartsvn.SmartSvnServices;
import com.syntevo.openapi.deprecated.smartsvn.action.ActionServices;
import com.syntevo.openapi.deprecated.smartsvn.command.ISvnCommand;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnDirectory;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnEntryQuery;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.ISvnFileDirectoryAction;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.SelectedSvnDirectories;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.SelectedSvnFiles;
import com.syntevo.openapi.deprecated.smartsvn.settings.Settings;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsUtils;
import com.syntevo.plugin.tagmultiple.TagMultipleProjectRootsDialog;
import com.syntevo.plugin.tagmultiple.TagMultipleProjectRootsSvnCommand;
import java.util.List;
import java.util.Set;

final class TagMultipleProjectRootsAction
implements ISvnFileDirectoryAction {
    public static final String ID = "com.syntevo.tagMultipleProjectRoots.TagMultipleProjectRoots";
    private static final int MAX_TAGS_TO_REMEMBER = 10;
    private static final String SETTINGS_KEY_FIX_EXTERNALS = "fixExternals";
    private static final String SETTINGS_KEY_PREVIOUS_TAGS = "previousTags";
    private static final String SETTINGS_KEY_COMMIT_MESSAGE = "commitMessage";
    private final SmartSvnServices services;
    private final Settings settings;

    public TagMultipleProjectRootsAction(SmartSvnServices services) {
        this.services = services;
        this.settings = services.getSettingsServices().getGlobalSettingsProvider().getSettings("com.syntevo.tagMultipleProjectRoots");
    }

    public boolean isApplicable(SelectedSvnFiles selectedFiles, SelectedSvnDirectories selectedDirectories) {
        Set directories = selectedDirectories.getDirectories();
        if (directories.isEmpty()) {
            return false;
        }
        for (SvnDirectory svnDirectory : directories) {
            if (svnDirectory.getPath().getRelativePath().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public void execute(SelectedSvnFiles selectedFiles, SvnEntryQuery entryQuery, ActionServices services) {
        throw new UnsupportedOperationException();
    }

    public void execute(SelectedSvnDirectories selectedDirectories, SvnEntryQuery entryQuery, final ActionServices services) {
        final Set svnDirectories = selectedDirectories.getDirectories();
        final List<String> previousTags = this.getPreviousTags();
        final TagMultipleProjectRootsDialog dialog = new TagMultipleProjectRootsDialog(previousTags, SettingsUtils.getBooleanValue((String)SETTINGS_KEY_FIX_EXTERNALS, (boolean)false, (Settings)this.settings), this.settings.getString(SETTINGS_KEY_COMMIT_MESSAGE, null), this.services.getGuiSpacings());
        services.getDialogDisplayer().showAsync((AbstractDialog)dialog, new IDialogResultHandler(){

            public void handleDialogResult(int value) {
                if (value != 2) {
                    return;
                }
                String tagName = dialog.getTagName();
                boolean fixExternals = dialog.isFixExternals();
                String commitMessage = dialog.getCommitMessage();
                TagMultipleProjectRootsAction.this.setPreviousTags(tagName, previousTags);
                SettingsUtils.setBooleanValue((String)TagMultipleProjectRootsAction.SETTINGS_KEY_FIX_EXTERNALS, (boolean)fixExternals, (Settings)TagMultipleProjectRootsAction.this.settings);
                TagMultipleProjectRootsAction.this.settings.putString(TagMultipleProjectRootsAction.SETTINGS_KEY_COMMIT_MESSAGE, commitMessage);
                services.scheduleCommand((ISvnCommand)new TagMultipleProjectRootsSvnCommand(tagName, svnDirectories, fixExternals, TagMultipleProjectRootsAction.this.services.getTagBranchLayouts(), commitMessage), "Tag with '" + tagName + "'");
            }
        });
    }

    private List<String> getPreviousTags() {
        return SettingsUtils.getStrings((String)SETTINGS_KEY_PREVIOUS_TAGS, (Settings)this.settings);
    }

    private void setPreviousTags(String tagName, List<String> previousTags) {
        previousTags.remove(tagName);
        previousTags.add(0, tagName);
        int i = previousTags.size();
        while (i-- > 10) {
            previousTags.remove(i);
        }
        SettingsUtils.setStrings((String)SETTINGS_KEY_PREVIOUS_TAGS, previousTags, (Settings)this.settings);
    }
}

