/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.transport;

import com.syntevo.openapi.deprecated.util.Assert;
import com.syntevo.openapi.deprecated.util.CompareUtils;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.trac.TracPlugin;
import com.syntevo.plugin.trac.transport.JsonRpcException;
import com.syntevo.plugin.trac.transport.TracClient;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueResolution;
import com.syntevo.plugin.trac.transport.TracIssueStatus;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class TracJsonRpcClient
extends TracClient {
    private static final String UTF8 = "UTF-8";
    private static final String JSON_OPTION_PREFIX = "&";
    private static final String JSON_OPTION_ASSIGNMENT = "=";
    private static final String JSON_FIELD_ID = "id";
    private static final String JSON_FIELD_MILESTONE = "milestone";
    private static final String JSON_FIELD_JSONCLASS = "__jsonclass__";
    private static final String JSON_FIELD_METHOD = "method";
    private static final String JSON_FIELD_PARAMS = "params";
    private static final String JSON_FIELD_ERROR = "error";
    private static final String JSON_FIELD_MESSAGE = "message";
    private static final String JSON_FIELD_NAME = "name";
    private static final String JSON_FIELD_DESCRIPTION = "description";
    private static final String JSON_FIELD_CODE = "code";
    private static final String JSON_FIELD_TIME = "time";
    private static final String JSON_FIELD_DUE = "due";
    private static final String JSON_FIELD_COMPLETED = "completed";
    private static final String JSON_FIELD_RESULT = "result";
    private static final String JSON_FIELD_MAX = "max";
    private static final String JSON_FIELD_ORDER = "order";
    private static final String JSON_FIELD_PAGE = "page";
    private static final String JSON_METHOD_SYSTEM_MULTICALL = "system.multicall";
    private static final String JSON_METHOD_TICKET_GET = "ticket.get";
    private static final String JSON_METHOD_TICKET_QUERY = "ticket.query";
    private static final String JSON_METHOD_TICKET_UPDATE = "ticket.update";
    private static final String JSON_METHOD_TICKET_VERSION_GET = "ticket.version.get";
    private static final String JSON_METHOD_TICKET_VERSION_GET_ALL = "ticket.version.getAll";
    private static final String JSON_METHOD_TICKET_MILESTONE_GET = "ticket.milestone.get";
    private static final String JSON_METHOD_TICKET_MILESTONE_GET_ALL = "ticket.milestone.getAll";
    private static final String JSON_METHOD_GET_API_VERSION = "system.getAPIVersion";
    private static final String JSON_TIMESTAMP_PATTERN = "yyyy-MM-ddHH:mm:ss";
    private int maxCount;
    private int currentPage;
    private boolean hasNextPage;
    private String queryParams = "";

    public TracJsonRpcClient(@NotNull BugtrackerConnection connection) {
        super(connection);
    }

    public void login() throws JsonRpcException, IOException {
        JSONObject requestObj = TracJsonRpcClient.createJSONRequest(JSON_METHOD_GET_API_VERSION, new Object[0]);
        this.sendProcessedJSONRequest(requestObj, JSONArray.class);
    }

    @NotNull
    public List<TracIssue> getFirstIssues(@Nullable String assignee, @NotNull List<TracIssueStatus> states, @NotNull List<TracIssueVersion> fixVersions, @NotNull List<TracIssueMilestone> fixMilestones, int maxCount) throws IOException, JsonRpcException {
        this.maxCount = maxCount;
        this.queryParams = TracJsonRpcClient.createQueryMainParams(assignee, fixVersions, fixMilestones, states);
        this.currentPage = 1;
        return this.getNextIssues();
    }

    @Nullable
    public TracIssue getIssueById(@NotNull Integer id) throws IOException {
        JSONObject requestObj = TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_GET, id);
        try {
            JSONArray result = (JSONArray)Assert.assertNotNull((Object)this.sendProcessedJSONRequest(requestObj, JSONArray.class));
            return TracJsonRpcClient.createTracIssue(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public List<TracIssueMilestone> getIncompleteMilestonesInOrder() throws IOException, JsonRpcException {
        JSONObject requestObj = TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_MILESTONE_GET_ALL, new Object[0]);
        JSONArray result = this.sendProcessedJSONRequest(requestObj, JSONArray.class);
        if (result == null) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> requests = new LinkedList<JSONObject>();
        for (Object obj : result) {
            String milestone = TracJsonRpcClient.getObjectOfTypeNotNull(obj, String.class);
            requests.add(TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_MILESTONE_GET, milestone));
        }
        result = (JSONArray)Assert.assertNotNull((Object)this.sendMultiCallJSONRequest(requests));
        LinkedList<TracIssueMilestone> milestones = new LinkedList<TracIssueMilestone>();
        for (Object obj : result) {
            JSONObject jsonObject = TracJsonRpcClient.getJSONObjectNotNull(obj);
            JSONObject resultObject = TracJsonRpcClient.getObjectOfTypeNotNull(jsonObject, JSON_FIELD_RESULT, JSONObject.class);
            String name = TracJsonRpcClient.getObjectOfTypeNotNull(resultObject, JSON_FIELD_NAME, String.class);
            String desc = TracJsonRpcClient.getObjectOfTypeNotNull(resultObject, JSON_FIELD_DESCRIPTION, String.class);
            Object dueObj = resultObject.get((Object)JSON_FIELD_DUE);
            Object completedObj = resultObject.get((Object)JSON_FIELD_COMPLETED);
            Date dueTime = TracJsonRpcClient.getNotMandatoryDateFromObject(dueObj);
            Date completedTime = TracJsonRpcClient.getNotMandatoryDateFromObject(completedObj);
            if (completedTime != null && !completedTime.after(new Date())) continue;
            milestones.add(new TracIssueMilestone(name, desc, dueTime, completedTime));
        }
        return milestones;
    }

    @NotNull
    public List<TracIssueVersion> getUnreleasedVersionsInOrder() throws IOException, JsonRpcException {
        JSONObject requestObj = TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_VERSION_GET_ALL, new Object[0]);
        JSONArray result = this.sendProcessedJSONRequest(requestObj, JSONArray.class);
        if (result == null) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> requests = new LinkedList<JSONObject>();
        for (Object obj : result) {
            String version = TracJsonRpcClient.getObjectOfTypeNotNull(obj, String.class);
            requests.add(TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_VERSION_GET, version));
        }
        result = (JSONArray)Assert.assertNotNull((Object)this.sendMultiCallJSONRequest(requests));
        LinkedList<TracIssueVersion> versions = new LinkedList<TracIssueVersion>();
        for (Object obj : result) {
            JSONObject jsonObject = TracJsonRpcClient.getJSONObjectNotNull(obj);
            JSONObject resultObject = TracJsonRpcClient.getObjectOfTypeNotNull(jsonObject, JSON_FIELD_RESULT, JSONObject.class);
            String name = TracJsonRpcClient.getObjectOfTypeNotNull(resultObject, JSON_FIELD_NAME, String.class);
            String desc = TracJsonRpcClient.getObjectOfTypeNotNull(resultObject, JSON_FIELD_DESCRIPTION, String.class);
            Object timeObj = resultObject.get((Object)JSON_FIELD_TIME);
            Date time = TracJsonRpcClient.getNotMandatoryDateFromObject(timeObj);
            if (time != null && !time.after(new Date())) continue;
            versions.add(new TracIssueVersion(name, desc, time));
        }
        return versions;
    }

    public void resolveIssue(@NotNull Integer issueKey, @NotNull String username, @NotNull TracIssueResolution resolution, @Nullable String fixVersion, @Nullable String fixMilestone) throws JsonRpcException, IOException {
        JSONObject attributes = new JSONObject();
        attributes.put((Object)"resolution", (Object)resolution.toString());
        attributes.put((Object)"status", (Object)TracIssueStatus.CLOSED.toString());
        if (fixVersion != null) {
            attributes.put((Object)"version", (Object)fixVersion);
        }
        if (fixMilestone != null) {
            attributes.put((Object)JSON_FIELD_MILESTONE, (Object)fixMilestone);
        }
        JSONObject requestObj = TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_UPDATE, issueKey, null, attributes, Boolean.FALSE, username, null);
        this.sendJSONRequest(requestObj);
    }

    @NotNull
    public List<TracIssue> getNextIssues() throws IOException, JsonRpcException {
        List<TracIssue> results;
        int max = this.maxCount;
        if (this.currentPage == 1) {
            ++max;
        } else if (!this.hasNextPage) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder(this.queryParams);
        builder.append(JSON_OPTION_PREFIX);
        builder.append(JSON_FIELD_PAGE);
        builder.append(JSON_OPTION_ASSIGNMENT);
        builder.append(this.currentPage);
        builder.append(JSON_OPTION_PREFIX);
        builder.append(JSON_FIELD_MAX);
        builder.append(JSON_OPTION_ASSIGNMENT);
        builder.append(max);
        try {
            results = this.readIssues(builder.toString());
        }
        catch (JsonRpcException e) {
            if (e.getErrorCode() == -32603L) {
                this.hasNextPage = false;
                return Collections.emptyList();
            }
            throw e;
        }
        if (this.currentPage == 1) {
            if (results.size() > this.maxCount) {
                results.remove(this.maxCount);
                this.hasNextPage = true;
            } else {
                this.hasNextPage = false;
            }
        }
        ++this.currentPage;
        return results;
    }

    @NotNull
    private JSONObject sendJSONRequest(@NotNull JSONObject request) throws JsonRpcException, IOException {
        Object replyObj;
        request.put((Object)JSON_FIELD_ID, (Object)System.currentTimeMillis());
        StringWriter out = new StringWriter();
        request.writeJSONString((Writer)out);
        String jsonText = out.toString();
        TracPlugin.LOGGER.debug("Sending request: " + jsonText);
        URL url = new URL(this.getBugtrackerConnection().getUrl());
        URLConnection urlConnection = this.createConnectableURL(url).openConnection();
        OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream(), UTF8);
        writer.write(jsonText);
        writer.flush();
        writer.close();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TracJsonRpcClient.copyStream(urlConnection.getInputStream(), bos);
        String content = new String(bos.toByteArray(), UTF8);
        TracPlugin.LOGGER.debug("Received reply: " + content);
        JSONParser parser = new JSONParser();
        try {
            replyObj = parser.parse(content);
            this.getBugtrackerConnection().acknowledgeSSLClientCertificate(true);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
        JSONObject reply = TracJsonRpcClient.getJSONObjectNotNull(replyObj);
        Long requestId = TracJsonRpcClient.getObjectOfType(request, JSON_FIELD_ID, Long.class);
        Long replyId = TracJsonRpcClient.getObjectOfType(reply, JSON_FIELD_ID, Long.class);
        JSONObject errorObj = TracJsonRpcClient.getObjectOfType(reply, JSON_FIELD_ERROR, JSONObject.class);
        if (errorObj != null) {
            String errorMsg = TracJsonRpcClient.getObjectOfTypeNotNull(errorObj, JSON_FIELD_MESSAGE, String.class);
            String errorName = TracJsonRpcClient.getObjectOfTypeNotNull(errorObj, JSON_FIELD_NAME, String.class);
            Long errorCode = TracJsonRpcClient.getObjectOfTypeNotNull(errorObj, JSON_FIELD_CODE, Long.class);
            throw new JsonRpcException(errorMsg, errorName, errorCode);
        }
        if (!CompareUtils.areEqual((Object)requestId, (Object)replyId)) {
            throw new IOException("Reply could not be assigned on the basis of the id.");
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        try {
            byte[] buffer = new byte[65536];
            int readBytes = inputStream.read(buffer);
            while (readBytes > 0) {
                outputStream.write(buffer, 0, readBytes);
                readBytes = inputStream.read(buffer);
            }
        }
        finally {
            outputStream.flush();
        }
    }

    @Nullable
    private <CLASS> CLASS sendProcessedJSONRequest(@NotNull JSONObject request, @NotNull Class<CLASS> replyClazz) throws IOException, JsonRpcException {
        return TracJsonRpcClient.getObjectOfType(this.sendJSONRequest(request), JSON_FIELD_RESULT, replyClazz);
    }

    @Nullable
    private JSONArray sendMultiCallJSONRequest(@NotNull List<JSONObject> requests) throws IOException, JsonRpcException {
        JSONObject mainRequest = TracJsonRpcClient.createJSONRequest(JSON_METHOD_SYSTEM_MULTICALL, requests.toArray());
        return this.sendProcessedJSONRequest(mainRequest, JSONArray.class);
    }

    @NotNull
    private List<TracIssue> readIssues(@NotNull String queryParams) throws IOException, JsonRpcException {
        JSONObject requestObj = TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_QUERY, queryParams);
        JSONArray ticketIds = this.sendProcessedJSONRequest(requestObj, JSONArray.class);
        if (ticketIds == null || ticketIds.size() == 0) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> ticketRequests = new LinkedList<JSONObject>();
        for (Object obj : ticketIds) {
            Long id = TracJsonRpcClient.getObjectOfTypeNotNull(obj, Long.class);
            ticketRequests.add(TracJsonRpcClient.createJSONRequest(JSON_METHOD_TICKET_GET, id));
        }
        JSONArray tickets = (JSONArray)Assert.assertNotNull((Object)this.sendMultiCallJSONRequest(ticketRequests));
        LinkedList<TracIssue> issues = new LinkedList<TracIssue>();
        for (Object obj : tickets) {
            JSONObject reply = TracJsonRpcClient.getJSONObjectNotNull(obj);
            issues.add(TracJsonRpcClient.createTracIssue(reply));
        }
        return issues;
    }

    @NotNull
    private static JSONObject createJSONRequest(@NotNull String method, Object ... params) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)JSON_FIELD_METHOD, (Object)method);
        if (params.length > 0) {
            JSONArray array = new JSONArray();
            array.addAll(Arrays.asList(params));
            jsonObj.put((Object)JSON_FIELD_PARAMS, (Object)array);
        }
        return jsonObj;
    }

    @NotNull
    private static TracIssue createTracIssue(@NotNull JSONArray jsonArray) throws IOException {
        Long id = TracJsonRpcClient.getObjectOfTypeNotNull(jsonArray.get(0), Long.class);
        TracIssue issue = new TracIssue(id);
        JSONObject attributes = TracJsonRpcClient.getJSONObjectNotNull(jsonArray.get(3));
        String statusStr = TracJsonRpcClient.getObjectOfTypeNotNull(attributes, "status", String.class);
        issue.setStatus(TracIssueStatus.parseFromId(statusStr));
        JSONObject changeTimeObj = TracJsonRpcClient.getObjectOfTypeNotNull(attributes, "changetime", JSONObject.class);
        issue.setChangeTime(TracJsonRpcClient.getParsedDateFromJSONObject(changeTimeObj));
        issue.setDescription(TracJsonRpcClient.getObjectOfType(attributes, JSON_FIELD_DESCRIPTION, String.class));
        issue.setReporter(TracJsonRpcClient.getObjectOfType(attributes, "reporter", String.class));
        issue.setCc(TracJsonRpcClient.getObjectOfType(attributes, "cc", String.class));
        issue.setResolution(TracJsonRpcClient.getObjectOfType(attributes, "resolution", String.class));
        JSONObject createdTimeObj = TracJsonRpcClient.getObjectOfTypeNotNull(attributes, JSON_FIELD_TIME, JSONObject.class);
        issue.setCreatedTime(TracJsonRpcClient.getParsedDateFromJSONObject(createdTimeObj));
        issue.setComponent(TracJsonRpcClient.getObjectOfType(attributes, "component", String.class));
        issue.setSummary(TracJsonRpcClient.getObjectOfType(attributes, "summary", String.class));
        issue.setPriority(TracJsonRpcClient.getObjectOfType(attributes, "priority", String.class));
        issue.setKeywords(TracJsonRpcClient.getObjectOfType(attributes, "keywords", String.class));
        issue.setVersionName(TracJsonRpcClient.getObjectOfType(attributes, "version", String.class));
        issue.setMilestoneName(TracJsonRpcClient.getObjectOfType(attributes, JSON_FIELD_MILESTONE, String.class));
        issue.setOwner(TracJsonRpcClient.getObjectOfType(attributes, "owner", String.class));
        issue.setType(TracJsonRpcClient.getObjectOfType(attributes, "type", String.class));
        return issue;
    }

    @Nullable
    private static Date getNotMandatoryDateFromObject(@NotNull Object dateObject) throws IOException {
        if (dateObject instanceof Number) {
            return null;
        }
        return TracJsonRpcClient.getParsedDateFromJSONObject(TracJsonRpcClient.getJSONObjectNotNull(dateObject));
    }

    @Nullable
    private static Date getParsedDateFromJSONObject(@NotNull JSONObject jsonObject) throws IOException {
        JSONArray dateArray = TracJsonRpcClient.getObjectOfTypeNotNull(jsonObject, JSON_FIELD_JSONCLASS, JSONArray.class);
        SimpleDateFormat dateFormat = new SimpleDateFormat(JSON_TIMESTAMP_PATTERN);
        String dateStr = TracJsonRpcClient.getObjectOfTypeNotNull(dateArray.get(1), String.class);
        dateStr = dateStr.replace("T", "");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return dateFormat.parse(dateStr);
        }
        catch (java.text.ParseException e) {
            TracPlugin.LOGGER.error("Couldn't parse the date string '" + dateStr + "'.");
            return null;
        }
    }

    @NotNull
    private static TracIssue createTracIssue(@NotNull JSONObject jsonObject) throws IOException {
        return TracJsonRpcClient.createTracIssue(TracJsonRpcClient.getObjectOfTypeNotNull(jsonObject, JSON_FIELD_RESULT, JSONArray.class));
    }

    private static String createQueryMainParams(@Nullable String assignee, @NotNull List<TracIssueVersion> fixVersions, @NotNull List<TracIssueMilestone> fixMilestones, @NotNull List<TracIssueStatus> states) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(JSON_FIELD_ORDER);
        builder.append(JSON_OPTION_ASSIGNMENT);
        builder.append(JSON_FIELD_MILESTONE);
        if (assignee != null) {
            builder.append(JSON_OPTION_PREFIX);
            builder.append("owner");
            builder.append(JSON_OPTION_ASSIGNMENT);
            builder.append(URLEncoder.encode(assignee, UTF8));
        }
        for (TracIssueStatus status : states) {
            builder.append(JSON_OPTION_PREFIX);
            builder.append("status");
            builder.append(JSON_OPTION_ASSIGNMENT);
            builder.append(status.toString());
        }
        for (TracIssueVersion fixVersion : fixVersions) {
            builder.append(JSON_OPTION_PREFIX);
            builder.append("version");
            builder.append(JSON_OPTION_ASSIGNMENT);
            if (fixVersion == null) continue;
            builder.append(URLEncoder.encode(fixVersion.getName(), UTF8));
        }
        for (TracIssueMilestone fixMilestone : fixMilestones) {
            builder.append(JSON_OPTION_PREFIX);
            builder.append(JSON_FIELD_MILESTONE);
            builder.append(JSON_OPTION_ASSIGNMENT);
            if (fixMilestone == null) continue;
            builder.append(URLEncoder.encode(fixMilestone.getName(), UTF8));
        }
        return builder.toString();
    }

    @NotNull
    private static JSONObject getJSONObjectNotNull(@NotNull Object object) throws IOException {
        return TracJsonRpcClient.getObjectOfTypeNotNull(object, JSONObject.class);
    }

    @Nullable
    private static <CLASS> CLASS getObjectOfType(@NotNull JSONObject parent, @NotNull String key, @NotNull Class<CLASS> clazz) throws IOException {
        Object obj = parent.get((Object)key);
        if (obj == null) {
            return null;
        }
        return TracJsonRpcClient.getObjectOfTypeNotNull(parent, key, clazz);
    }

    @NotNull
    private static <CLASS> CLASS getObjectOfTypeNotNull(@NotNull JSONObject parent, @NotNull String key, @NotNull Class<CLASS> clazz) throws IOException {
        Object obj = parent.get((Object)key);
        if (obj == null) {
            throw new IOException("Object '" + key + "' not found.");
        }
        if (!clazz.isInstance(obj)) {
            throw new IOException("Object '" + key + "' has unexpected type.");
        }
        return (CLASS)obj;
    }

    @NotNull
    private static <CLASS> CLASS getObjectOfTypeNotNull(@NotNull Object object, @NotNull Class<CLASS> clazz) throws IOException {
        if (!clazz.isInstance(object)) {
            throw new IOException("Object has unexpected type.");
        }
        return (CLASS)object;
    }
}

