/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.workflow;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import com.syntevo.openapi.deprecated.util.UiUtils;
import com.syntevo.plugin.trac.commit.workflow.TracResolvablePacket;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TracResolveIssueDialog
extends AbstractOkCancelDialog {
    private static final boolean USE_EMPTY_VERSION = true;
    private static final boolean USE_EMPTY_MILESTONE = true;
    private final String message;
    private final List<TracIssueVersion> unreleasedVersions;
    private final List<TracIssueMilestone> incompleteMilestones;
    private final GuiSpacings spacings;
    private Button resolveButton;
    private Combo fixVersionComboBox;
    private Combo fixMilestoneComboBox;
    private Button dontResolveButton;
    private final String defaultVersion;
    private final String defaultMilestone;
    private boolean doResolve;
    private String fixVersion;
    private String fixMilestone;

    @NotNull
    public static TracResolveIssueDialog getInstance(@NotNull TracResolvablePacket packet, @NotNull GuiSpacings spacings) {
        List<TracIssueVersion> unreleasedVersions = packet.getUnreleasedVersions();
        List<TracIssueMilestone> incompleteMilestones = packet.getIncompleteMilestones();
        TracIssue issue = packet.getIssue();
        String defaultVersion = issue.getVersionName();
        String defaultMilestone = issue.getMilestoneName();
        String summary = issue.getSummary();
        String message = "Do you want to resolve issue " + issue.getId();
        if (summary != null) {
            if (summary.length() > 50) {
                summary = summary.substring(0, 47) + "...";
            }
            message = message + ": " + summary;
        }
        message = message + "?";
        return new TracResolveIssueDialog(message, unreleasedVersions, incompleteMilestones, defaultVersion, defaultMilestone, spacings);
    }

    private TracResolveIssueDialog(@NotNull String message, @NotNull List<TracIssueVersion> unreleasedVersions, @NotNull List<TracIssueMilestone> incompleteMilestones, @Nullable String defaultVersion, @Nullable String defaultMilestone, @NotNull GuiSpacings spacings) {
        this.message = message;
        this.unreleasedVersions = unreleasedVersions;
        this.incompleteMilestones = incompleteMilestones;
        this.defaultVersion = defaultVersion;
        this.defaultMilestone = defaultMilestone;
        this.spacings = spacings;
    }

    @NotNull
    public String getTitle() {
        return "Resolve Trac Issue";
    }

    @NotNull
    public Control createComponent(@NotNull Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = this.spacings.getXRelated();
        layout.verticalSpacing = this.spacings.getYUnrelated();
        panel.setLayout((Layout)layout);
        Label messageLabel = UiUtils.createLabel((String)this.message, (Composite)panel);
        messageLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label emptyLabel = UiUtils.createLabel((String)"", (Composite)panel);
        emptyLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.dontResolveButton = UiUtils.createRadioButton((String)"Don't mark as resolved", (Composite)panel);
        this.dontResolveButton.setLayoutData((Object)new GridData(16384, 4, false, false, 2, 1));
        this.dontResolveButton.setSelection(true);
        this.resolveButton = UiUtils.createRadioButton((String)"Mark as resolved", (Composite)panel);
        this.resolveButton.setLayoutData((Object)new GridData(16384, 4, false, false, 2, 1));
        Label resolveVersion = UiUtils.createLabel((String)"Version:", (Composite)panel);
        resolveVersion.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.fixVersionComboBox = new Combo(panel, 2056);
        this.fixVersionComboBox.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] versionNames = new String[this.unreleasedVersions.size()];
        int indexToSelect = -1;
        for (int i = 0; i < versionNames.length; ++i) {
            TracIssueVersion version = this.unreleasedVersions.get(i);
            versionNames[i] = version.getName();
            if (indexToSelect >= 0 || !versionNames[i].equals(this.defaultVersion)) continue;
            indexToSelect = i;
        }
        this.fixVersionComboBox.setItems(versionNames);
        if (indexToSelect >= 0) {
            this.fixVersionComboBox.select(indexToSelect);
        }
        this.fixVersionComboBox.add("", 0);
        Label resolveMilestone = UiUtils.createLabel((String)"Milestone:", (Composite)panel);
        resolveMilestone.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.fixMilestoneComboBox = new Combo(panel, 2056);
        this.fixMilestoneComboBox.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] milestoneNames = new String[this.incompleteMilestones.size()];
        indexToSelect = -1;
        for (int i = 0; i < milestoneNames.length; ++i) {
            TracIssueMilestone milestone = this.incompleteMilestones.get(i);
            milestoneNames[i] = milestone.getName();
            if (indexToSelect >= 0 || !milestoneNames[i].equals(this.defaultMilestone)) continue;
            indexToSelect = i;
        }
        this.fixMilestoneComboBox.setItems(milestoneNames);
        if (indexToSelect >= 0) {
            this.fixMilestoneComboBox.select(indexToSelect);
        }
        this.fixMilestoneComboBox.add("", 0);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracResolveIssueDialog.this.updateEnabledStates();
            }
        };
        this.resolveButton.addSelectionListener((SelectionListener)selectionListener);
        this.dontResolveButton.addSelectionListener((SelectionListener)selectionListener);
        this.updateEnabledStates();
        return panel;
    }

    public void dialogShowing() {
        super.dialogShowing();
        if (this.fixVersionComboBox.isEnabled()) {
            this.fixVersionComboBox.setFocus();
        } else if (this.fixMilestoneComboBox.isEnabled()) {
            this.fixMilestoneComboBox.setFocus();
        } else {
            this.dontResolveButton.setFocus();
        }
    }

    protected void ok() throws DialogValidationFailedException {
        this.doResolve = this.resolveButton.getSelection();
        this.fixVersion = null;
        this.fixMilestone = null;
        if (this.doResolve) {
            int selIdx = this.fixVersionComboBox.getSelectionIndex();
            if (selIdx > -1) {
                this.fixVersion = this.fixVersionComboBox.getItem(this.fixVersionComboBox.getSelectionIndex());
            }
            if ((selIdx = this.fixMilestoneComboBox.getSelectionIndex()) > -1) {
                this.fixMilestone = this.fixMilestoneComboBox.getItem(this.fixMilestoneComboBox.getSelectionIndex());
            }
        }
        super.ok();
    }

    @Nullable
    public String getFixVersion() {
        if (this.fixVersion == null || this.fixVersion.isEmpty()) {
            return null;
        }
        return this.fixVersion;
    }

    @Nullable
    public String getFixMilestone() {
        if (this.fixMilestone == null || this.fixMilestone.isEmpty()) {
            return null;
        }
        return this.fixMilestone;
    }

    public boolean doResolve() {
        return this.doResolve;
    }

    private void updateEnabledStates() {
        this.fixVersionComboBox.setEnabled(this.resolveButton.getSelection());
        this.fixMilestoneComboBox.setEnabled(this.resolveButton.getSelection());
    }
}

