/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.workflow;

import com.syntevo.plugin.trac.commit.TracUIConnection;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TracResolvablePacket {
    private final Integer issueId;
    private final TracUIConnection connection;
    private TracIssue issue;
    private List<TracIssueVersion> unreleasedVersions = new LinkedList<TracIssueVersion>();
    private List<TracIssueMilestone> incompleteMilestones = new LinkedList<TracIssueMilestone>();

    public TracResolvablePacket(@NotNull Integer issueId, @NotNull TracUIConnection connection) {
        this.issueId = issueId;
        this.connection = connection;
    }

    public String toString() {
        return this.issueId.toString();
    }

    public int hashCode() {
        return this.issueId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TracResolvablePacket packet = (TracResolvablePacket)obj;
        return this.issueId.equals(packet.issueId) && this.connection.getUrl().equals(packet.connection.getUrl());
    }

    @NotNull
    public Integer getIssueId() {
        return this.issueId;
    }

    @NotNull
    public TracUIConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public TracIssue getIssue() {
        return this.issue;
    }

    public void setIssue(@NotNull TracIssue issue) {
        this.issue = issue;
    }

    @NotNull
    public List<TracIssueVersion> getUnreleasedVersions() {
        return this.unreleasedVersions;
    }

    public void setUnreleasedVersions(@NotNull List<TracIssueVersion> unreleasedVersions) {
        this.unreleasedVersions = new ArrayList<TracIssueVersion>(unreleasedVersions);
    }

    @NotNull
    public List<TracIssueMilestone> getIncompleteMilestones() {
        return this.incompleteMilestones;
    }

    public void setIncompleteMilestones(@NotNull List<TracIssueMilestone> incompleteMilestones) {
        this.incompleteMilestones = new ArrayList<TracIssueMilestone>(incompleteMilestones);
    }
}

