/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.workflow;

import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.smartsvn.command.SvnClients;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterPostCommandPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPostCommandPhase;
import com.syntevo.openapi.deprecated.smartsvn.file.Path;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.trac.TracPlugin;
import com.syntevo.plugin.trac.commit.workflow.TracResolvePacket;
import com.syntevo.plugin.trac.transport.TracIssueResolution;
import com.syntevo.plugin.trac.transport.TracJsonRpcClient;
import java.util.List;
import java.util.Map;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.SubversionException;
import org.jetbrains.annotations.NotNull;

final class TracPostCommandPhase
extends FilterPostCommandPhase {
    private final List<TracResolvePacket> resolvePackets;
    private final DialogDisplayer dialogDisplayer;

    public TracPostCommandPhase(@NotNull ICommitPostCommandPhase wrappedPhase, @NotNull List<TracResolvePacket> resolvePackets, @NotNull DialogDisplayer dialogDisplayer) {
        super(wrappedPhase);
        this.resolvePackets = resolvePackets;
        this.dialogDisplayer = dialogDisplayer;
    }

    public void process(@NotNull Map<Path, ClientNotifyInformation> pathToClientNotifyInformation, @NotNull SvnClients svnClients) throws SubversionException {
        super.process(pathToClientNotifyInformation, svnClients);
        TracPlugin.LOGGER.debug("Resolving packets");
        for (TracResolvePacket resolvePacket : this.resolvePackets) {
            TracPlugin.LOGGER.info("Resolving " + resolvePacket);
            BugtrackerConnection connection = resolvePacket.getConnection();
            Integer issueId = resolvePacket.getIssueId();
            TracJsonRpcClient queryClient = new TracJsonRpcClient(connection);
            try {
                queryClient.resolveIssue(issueId, connection.getUsername(), TracIssueResolution.FIXED, resolvePacket.getFixVersion(), resolvePacket.getFixMilestone());
                TracPlugin.LOGGER.warn(" ... resolved");
            }
            catch (Exception ex) {
                TracPlugin.LOGGER.error(ex.getMessage(), (Throwable)ex);
                this.dialogDisplayer.showErrorDialogSync("Trac", ex.getMessage(), null);
            }
        }
    }
}

