/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.workflow;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogFactory;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitBugtraqProperties;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitPacket;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitPacketPhaseState;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterCommitPacketPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPacketPhase;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.openapi.deprecated.smartsvn.thread.IJob;
import com.syntevo.openapi.deprecated.smartsvn.thread.IJobSuccessRunnable;
import com.syntevo.openapi.deprecated.smartsvn.thread.JobExecutor;
import com.syntevo.openapi.deprecated.smartsvn.thread.ProgressViewer;
import com.syntevo.openapi.deprecated.util.UiUtils;
import com.syntevo.plugin.trac.TracPlugin;
import com.syntevo.plugin.trac.commit.TracUIConnection;
import com.syntevo.plugin.trac.commit.TracUrl;
import com.syntevo.plugin.trac.commit.workflow.TracResolvablePacket;
import com.syntevo.plugin.trac.commit.workflow.TracResolveIssueDialog;
import com.syntevo.plugin.trac.commit.workflow.TracResolvePacket;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueStatus;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import com.syntevo.plugin.trac.transport.TracJsonRpcClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TracFilesPhase
extends FilterCommitPacketPhase {
    private static final boolean RESOLVE_ENABLED = "true".equals(System.getProperty("smartsvn.plugin.trac.show-resolveIssue-dialog", "true"));
    private final SettingsServices settingsServices;
    private final JobExecutor jobExecutor;
    private final DialogDisplayer dialogDisplayer;
    private final GuiSpacings spacings;
    private List<TracResolvePacket> selectedResolvePackets;

    public TracFilesPhase(@NotNull ICommitPacketPhase internalPhase, @NotNull SettingsServices settingsServices, @NotNull JobExecutor jobExecutor, @NotNull GuiSpacings spacings, DialogDisplayer dialogDisplayer) {
        super(internalPhase);
        this.settingsServices = settingsServices;
        this.jobExecutor = jobExecutor;
        this.dialogDisplayer = dialogDisplayer;
        this.spacings = spacings;
    }

    public void updateTo(final @NotNull CommitPacketPhaseState state, final @NotNull Runnable successRunnable) {
        super.updateTo(state, new Runnable(){

            @Override
            public void run() {
                TracFilesPhase.this.selectedResolvePackets = null;
                if (!RESOLVE_ENABLED) {
                    successRunnable.run();
                    return;
                }
                HashSet allResolvablePackets = new HashSet();
                for (CommitPacket packet : new ArrayList(state.getPackets())) {
                    allResolvablePackets.addAll(TracFilesPhase.extractResolvablePackets(packet, TracFilesPhase.this.settingsServices, TracFilesPhase.this.spacings, TracFilesPhase.this.dialogDisplayer));
                }
                if (allResolvablePackets.isEmpty()) {
                    successRunnable.run();
                    return;
                }
                TracFilesPhase.this.processResolvablePackets(allResolvablePackets, TracFilesPhase.this.jobExecutor, successRunnable, TracFilesPhase.this.dialogDisplayer);
            }
        });
    }

    @Nullable
    public List<TracResolvePacket> getResolvePackets() {
        UiUtils.assertThreadAccess();
        return this.selectedResolvePackets != null ? Collections.unmodifiableList(this.selectedResolvePackets) : null;
    }

    private void processResolvablePackets(@NotNull Set<TracResolvablePacket> allResolvablePackets, @NotNull JobExecutor jobExecutor, final Runnable successRunnable, final @NotNull DialogDisplayer dialogDisplayer) {
        TracPlugin.LOGGER.debug("Filtering resolvable packets");
        final ArrayList<TracResolvablePacket> resolvablePacketsInOrder = new ArrayList<TracResolvablePacket>(allResolvablePackets);
        Collections.sort(resolvablePacketsInOrder, new Comparator<TracResolvablePacket>(){

            @Override
            public int compare(TracResolvablePacket o1, TracResolvablePacket o2) {
                return o1.getIssueId().compareTo(o2.getIssueId());
            }
        });
        jobExecutor.executeAsync("Trac", new IJob(){

            public IJobSuccessRunnable execute(@NotNull ProgressViewer progressViewer) {
                int progress = 0;
                ArrayList<TracResolvablePacket> resolvablePackets = new ArrayList<TracResolvablePacket>();
                for (TracResolvablePacket packet : resolvablePacketsInOrder) {
                    progressViewer.setMessage("Querying " + packet.getConnection().getUrl());
                    progressViewer.setProgress(progress++, resolvablePacketsInOrder.size());
                    try {
                        TracJsonRpcClient client = new TracJsonRpcClient(packet.getConnection());
                        TracIssue issue = client.getIssueById(packet.getIssueId());
                        if (issue == null) {
                            TracPlugin.LOGGER.debug(" ... " + packet + " not exists in Trac");
                            continue;
                        }
                        if (!TracFilesPhase.isResolvable(issue)) {
                            TracPlugin.LOGGER.debug(" ... " + packet + " not resolvable (status=" + issue.getStatus() + ")");
                            continue;
                        }
                        List<TracIssueVersion> unreleasedVersions = client.getUnreleasedVersionsInOrder();
                        List<TracIssueMilestone> incompleteMilestones = client.getIncompleteMilestonesInOrder();
                        packet.setIssue(issue);
                        packet.setUnreleasedVersions(unreleasedVersions);
                        packet.setIncompleteMilestones(incompleteMilestones);
                        resolvablePackets.add(packet);
                        TracPlugin.LOGGER.debug(" ... " + packet + " is resolvable.");
                    }
                    catch (Exception ex) {
                        TracPlugin.LOGGER.error(ex.getMessage(), (Throwable)ex);
                        dialogDisplayer.showErrorDialogSync("Trac", ex.getMessage(), null);
                    }
                }
                TracFilesPhase.this.selectedResolvePackets = TracFilesPhase.this.chooseResolvePackets(resolvablePackets);
                return new IJobSuccessRunnable(){

                    public void runInEdt(@NotNull DialogDisplayer dialogDisplayer) {
                        if (TracFilesPhase.this.selectedResolvePackets != null) {
                            successRunnable.run();
                        }
                    }
                };
            }
        });
    }

    @Nullable
    private List<TracResolvePacket> chooseResolvePackets(@NotNull List<TracResolvablePacket> resolvablePackets) {
        ArrayList<TracResolvePacket> selectedResolvePackets = new ArrayList<TracResolvePacket>();
        for (final TracResolvablePacket packet : resolvablePackets) {
            TracResolveIssueDialog resolveIssueDialog = (TracResolveIssueDialog)this.dialogDisplayer.showSync((IDialogFactory)new IDialogFactory<TracResolveIssueDialog>(){

                @NotNull
                public TracResolveIssueDialog createDialog() {
                    return TracResolveIssueDialog.getInstance(packet, TracFilesPhase.this.spacings);
                }
            });
            if (resolveIssueDialog == null) {
                TracPlugin.LOGGER.debug(" ... " + packet + " cancelled");
                return null;
            }
            if (!resolveIssueDialog.doResolve()) {
                TracPlugin.LOGGER.debug(" ... " + packet + " not selected");
                continue;
            }
            TracPlugin.LOGGER.debug(" ... " + packet + " selected");
            String fixVersion = resolveIssueDialog.getFixVersion();
            String fixMilestone = resolveIssueDialog.getFixMilestone();
            selectedResolvePackets.add(new TracResolvePacket(packet.getConnection(), packet.getIssueId(), fixVersion, fixMilestone));
        }
        return selectedResolvePackets;
    }

    private static boolean isResolvable(@NotNull TracIssue issue) {
        TracIssueStatus status = issue.getStatus();
        return status == TracIssueStatus.ACCEPTED || status == TracIssueStatus.ASSIGNED || status == TracIssueStatus.REOPENED || status == TracIssueStatus.NEW;
    }

    @NotNull
    private static Collection<TracResolvablePacket> extractResolvablePackets(@NotNull CommitPacket packet, @NotNull SettingsServices settingsServices, @NotNull GuiSpacings spacings, @NotNull DialogDisplayer dialogDisplayer) {
        TracPlugin.LOGGER.debug("Extracting resolvable packets for " + packet.getCommitRoot());
        CommitBugtraqProperties bugtraqProperties = packet.getBugtraqProperties();
        if (bugtraqProperties == null) {
            TracPlugin.LOGGER.debug(" ... no bugtraq-properties");
            return Collections.emptyList();
        }
        String urlStr = bugtraqProperties.getURL();
        if (urlStr == null) {
            TracPlugin.LOGGER.debug(" ... no bugtraq URL");
            return Collections.emptyList();
        }
        TracUrl url = TracUrl.parseFromBugtraqUrls(urlStr);
        if (url == null) {
            TracPlugin.LOGGER.debug(" ... no valid Trac URL");
            return Collections.emptyList();
        }
        TracPlugin.LOGGER.debug(" ... URL is " + url);
        String message = packet.getMessage();
        ArrayList<TracResolvablePacket> resolvePackets = new ArrayList<TracResolvablePacket>();
        TracUIConnection connection = new TracUIConnection(url.getBaseUrl(), settingsServices, true, spacings, dialogDisplayer);
        TracPlugin.LOGGER.debug("Parsing message '" + message + "'");
        if (message != null) {
            List issueIds = bugtraqProperties.parseIssueIds(message);
            if (issueIds == null) {
                return Collections.emptyList();
            }
            for (String idStr : issueIds) {
                try {
                    resolvePackets.add(new TracResolvablePacket(Integer.valueOf(idStr), connection));
                    TracPlugin.LOGGER.debug(" ... found issue " + idStr);
                }
                catch (NumberFormatException e) {
                    TracPlugin.LOGGER.error(" ... skip invalid issue id " + idStr);
                }
            }
        }
        return resolvePackets;
    }
}

