/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.openapi.deprecated.util.CompareUtils;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueStatus;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TracIssueByRelevanceComparator
implements Comparator<TracIssue> {
    private final List<TracIssueVersion> unreleasedVersions;
    private final List<TracIssueMilestone> incompleteMilestones;

    public TracIssueByRelevanceComparator(@NotNull List<TracIssueVersion> unreleasedVersions, @NotNull List<TracIssueMilestone> incompleteMilestones) {
        this.unreleasedVersions = unreleasedVersions;
        this.incompleteMilestones = incompleteMilestones;
    }

    @Override
    public int compare(TracIssue o1, TracIssue o2) {
        if (o1 == null || o2 == null) {
            return CompareUtils.compareForNull((Object)o1, (Object)o2);
        }
        TracIssueStatus firstStatus = o1.getStatus();
        TracIssueStatus secondStatus = o2.getStatus();
        if (firstStatus.getPriority() != secondStatus.getPriority()) {
            if (firstStatus.getPriority() < secondStatus.getPriority()) {
                return -1;
            }
            return 1;
        }
        String firstMilestone = o1.getMilestoneName();
        String secondMilestone = o2.getMilestoneName();
        String firstVersion = o1.getVersionName();
        String secondVersion = o2.getVersionName();
        int compMilestone = TracIssueByRelevanceComparator.compareVersionOrMilestone(this.getIncompletedMilestoneIndexByName(firstMilestone), this.getIncompletedMilestoneIndexByName(secondMilestone));
        if (compMilestone != 0) {
            return compMilestone;
        }
        int compVersion = TracIssueByRelevanceComparator.compareVersionOrMilestone(this.getUnreleasedVersionIndexByName(firstVersion), this.getUnreleasedVersionIndexByName(secondVersion));
        if (compVersion != 0) {
            return compVersion;
        }
        if (o1.getId() > o2.getId()) {
            return -1;
        }
        return 1;
    }

    private int getIncompletedMilestoneIndexByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        for (int cnt = 0; cnt < this.incompleteMilestones.size(); ++cnt) {
            TracIssueMilestone milestone = this.incompleteMilestones.get(cnt);
            if (milestone == null || !milestone.getName().equals(name)) continue;
            return cnt;
        }
        return -1;
    }

    private int getUnreleasedVersionIndexByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        for (int cnt = 0; cnt < this.unreleasedVersions.size(); ++cnt) {
            TracIssueVersion version = this.unreleasedVersions.get(cnt);
            if (version == null || !version.getName().equals(name)) continue;
            return cnt;
        }
        return -1;
    }

    public static int compareVersionOrMilestone(int idx1, int idx2) {
        if (idx1 == idx2) {
            return 0;
        }
        if (idx1 == -1) {
            return 1;
        }
        if (idx2 == -1) {
            return -1;
        }
        if (idx1 < idx2) {
            return -1;
        }
        return 1;
    }
}

