/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogResultHandler;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitBugtraqProperties;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitMessageSource;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.openapi.deprecated.util.CompareUtils;
import com.syntevo.openapi.deprecated.util.Consumer;
import com.syntevo.plugin.trac.commit.TracUIConnection;
import com.syntevo.plugin.trac.commit.messagesource.TracCommitMessageSourceDialog;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueLoader;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueTable;
import com.syntevo.plugin.trac.commit.messagesource.TracQueryConfiguration;
import com.syntevo.plugin.trac.transport.TracIssue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;

final class TracCommitMessageSource
implements ICommitMessageSource,
TracIssueTable {
    private final DialogDisplayer dialogDisplayer;
    private final TracIssueLoader issueLoader;
    private final TracQueryConfiguration queryConfiguration;
    private final CommitBugtraqProperties bugtraqProperties;
    private List<TracIssue> pendingIssues = new ArrayList<TracIssue>();
    private TracCommitMessageSourceDialog currentDialog;
    private final TracUIConnection uiConnection;
    private static final String DEFAULT_COMMIT_MESSAGE_PATTERN = "#%BUGID%: %MESSAGE%";

    public TracCommitMessageSource(@NotNull String baseUrl, @NotNull SettingsServices settingsServices, @NotNull CommitBugtraqProperties bugtraqProperties, @NotNull GuiSpacings spacings, @NotNull DialogDisplayer dialogDisplayer) {
        this.bugtraqProperties = bugtraqProperties;
        this.dialogDisplayer = dialogDisplayer;
        this.issueLoader = new TracIssueLoader(this);
        this.issueLoader.start();
        boolean loadAll = "true".equals(System.getProperty("smartsvn.plugin.trac.load-all-issues", "false"));
        this.uiConnection = new TracUIConnection(baseUrl, settingsServices, false, spacings, dialogDisplayer);
        this.queryConfiguration = new TracQueryConfiguration(this.uiConnection, loadAll);
        TracQueryConfiguration silentQueryConfiguration = new TracQueryConfiguration(new TracUIConnection(baseUrl, settingsServices, true, spacings, dialogDisplayer), loadAll);
        this.issueLoader.load(silentQueryConfiguration, true);
    }

    @NotNull
    public String getMenuItemName() {
        return "Get from Trac...";
    }

    public void getCommitMessage(final @NotNull Consumer<String> consumer) {
        TracCommitMessageSourceDialog dialog;
        String commitMessagePattern = this.uiConnection.getCommitMessagePattern();
        if (commitMessagePattern == null) {
            commitMessagePattern = DEFAULT_COMMIT_MESSAGE_PATTERN;
        }
        this.currentDialog = dialog = new TracCommitMessageSourceDialog(this.pendingIssues, this.issueLoader, this.queryConfiguration, commitMessagePattern, this.bugtraqProperties, this.dialogDisplayer);
        this.issueLoader.load(this.queryConfiguration, false);
        this.dialogDisplayer.showAsync((AbstractDialog)this.currentDialog, new IDialogResultHandler(){

            public void handleDialogResult(int value) {
                if (value != 2) {
                    return;
                }
                if (TracCommitMessageSource.this.bugtraqProperties.getMessage() == null && !CompareUtils.areEqual((Object)TracCommitMessageSource.this.uiConnection.getCommitMessagePattern(), (Object)dialog.getCommitMessagePattern())) {
                    TracCommitMessageSource.this.uiConnection.storeCommitMessagePattern(dialog.getCommitMessagePattern());
                }
                consumer.consumer((Object)dialog.getCommitMessage());
            }
        });
    }

    public void cleanup() {
        this.issueLoader.abortAndCleanup();
    }

    @Override
    public void setIssues(final @NotNull List<TracIssue> issues) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TracCommitMessageSource.this.pendingIssues = new ArrayList(issues);
                if (TracCommitMessageSource.this.currentDialog != null) {
                    TracCommitMessageSource.this.currentDialog.setIssues(TracCommitMessageSource.this.pendingIssues);
                }
            }
        });
    }
}

