/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

class BugtrackerDebugLoggingLogStream
extends OutputStream {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
    private final String prefix;
    private final PrintWriter log;

    public BugtrackerDebugLoggingLogStream(@NotNull PrintWriter log, @NotNull String prefix) {
        this.log = log;
        this.prefix = prefix;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
        this.flushBuffer(false);
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
        this.flushBuffer(false);
    }

    public void flushBuffer(boolean force) {
        if (!force && this.buffer.size() < 1024) {
            return;
        }
        if (this.buffer.size() > 0) {
            this.log.println(DATE_FORMAT.format(new Date()) + " " + this.prefix + new String(this.buffer.toByteArray()));
            this.log.flush();
        }
        this.buffer.reset();
    }
}

