/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerDebugLoggingInputStream;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerDebugLoggingLogStream;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerDebugLoggingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BugtrackerDebugLoggingConnection
extends HttpURLConnection {
    private final HttpURLConnection connection;
    private final PrintWriter log;
    private InputStream internalIs;
    private OutputStream internalOs;
    private InputStream internalErr;
    private InputStream is;
    private OutputStream os;
    private InputStream err;

    public BugtrackerDebugLoggingConnection(@NotNull URL url, @NotNull HttpURLConnection connection, @NotNull PrintWriter log) {
        super(url);
        this.connection = connection;
        this.log = log;
    }

    @Override
    public void connect() throws IOException {
        this.connection.connect();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    @Override
    @Nullable
    public InputStream getErrorStream() {
        InputStream internalErr = this.connection.getErrorStream();
        if (internalErr == this.internalErr) {
            return this.err;
        }
        this.internalErr = internalErr;
        this.err = new BugtrackerDebugLoggingInputStream(internalErr, new BugtrackerDebugLoggingLogStream(this.log, "ERROR: "));
        return this.err;
    }

    @Override
    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.connection.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        return this.connection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.connection.getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.connection.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    @Override
    public long getDate() {
        return this.connection.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    @Override
    public long getExpiration() {
        return this.connection.getExpiration();
    }

    @Override
    public String getHeaderField(int n) {
        return this.connection.getHeaderField(n);
    }

    @Override
    public String getHeaderField(String name) {
        return this.connection.getHeaderField(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return this.connection.getHeaderFieldDate(name, Default);
    }

    @Override
    public int getHeaderFieldInt(String name, int Default) {
        return this.connection.getHeaderFieldInt(name, Default);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.connection.getHeaderFieldKey(n);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.connection.getHeaderFields();
    }

    @Override
    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream internalIs = this.connection.getInputStream();
        if (internalIs == this.internalIs) {
            return this.is;
        }
        this.internalIs = internalIs;
        this.is = new BugtrackerDebugLoggingInputStream(internalIs, new BugtrackerDebugLoggingLogStream(this.log, "READ: "));
        return this.is;
    }

    @Override
    public long getLastModified() {
        return this.connection.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream internalOs = this.connection.getOutputStream();
        if (internalOs == this.internalOs) {
            return this.os;
        }
        this.internalOs = internalOs;
        this.os = new BugtrackerDebugLoggingOutputStream(internalOs, new BugtrackerDebugLoggingLogStream(this.log, "WRITE: "));
        return this.os;
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.connection.getPermission();
    }

    @Override
    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        this.connection.setChunkedStreamingMode(chunklen);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.connection.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.connection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.connection.setRequestMethod(method);
    }

    @Override
    public int getReadTimeout() {
        return this.connection.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.connection.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.connection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.connection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setDoInput(boolean doinput) {
        this.connection.setDoInput(doinput);
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.connection.setDoOutput(dooutput);
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.connection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.connection.setRequestProperty(key, value);
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.connection.setUseCaches(usecaches);
    }

    @Override
    public String toString() {
        return this.connection.toString();
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.connection.addRequestProperty(key, value);
    }
}

