/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.commit;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import com.syntevo.openapi.deprecated.util.UiUtils;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BugtrackerClientCertificateDialog
extends AbstractOkCancelDialog {
    private final String title;
    private final GuiSpacings spacings;
    private Text certificateTextField;
    private Text passphraseField;
    private Button storePassphraseCheckBox;
    private File certificate;
    private String passphrase;
    private boolean storePassphrase;

    public BugtrackerClientCertificateDialog(@NotNull String title, @Nullable File certificate, @Nullable String passphrase, boolean storePassphrase, @NotNull GuiSpacings spacings) {
        this.title = title;
        this.certificate = certificate;
        this.passphrase = passphrase;
        this.storePassphrase = storePassphrase;
        this.spacings = spacings;
        this.getOkAction().setName("Login");
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public Control createComponent(@NotNull Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = this.spacings.getXRelated();
        layout.verticalSpacing = this.spacings.getYUnrelated();
        panel.setLayout((Layout)layout);
        Label certificateLabel = UiUtils.createLabel((String)"&Certificate File:", (Composite)panel);
        certificateLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.certificateTextField = UiUtils.createTextField(null, (Composite)panel);
        if (this.certificate != null) {
            UiUtils.setText((Text)this.certificateTextField, (String)this.certificate.getAbsolutePath());
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 200;
        this.certificateTextField.setLayoutData((Object)gridData);
        Button certificateFileChooserButton = UiUtils.createButton((String)"Select...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugtrackerClientCertificateDialog.this.showFileChooser();
            }
        }, (Composite)panel);
        certificateFileChooserButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label passphraseLabel = UiUtils.createLabel((String)"&Passphrase:", (Composite)panel);
        passphraseLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.passphraseField = UiUtils.createPasswordField((this.passphrase != null ? 1 : 0) != 0, (Composite)panel);
        this.passphraseField.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.storePassphraseCheckBox = UiUtils.createCheckBox((String)"&Store passphrase", (Composite)panel);
        this.storePassphraseCheckBox.setSelection(this.storePassphrase);
        this.storePassphraseCheckBox.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        return panel;
    }

    public void ok() throws DialogValidationFailedException {
        File certificate;
        String certificateFileName = this.certificateTextField.getText();
        File file = certificate = certificateFileName.length() > 0 ? new File(certificateFileName) : null;
        if (certificate == null || !certificate.isFile()) {
            throw new DialogValidationFailedException((Control)this.certificateTextField, "Please select the certificate file.", "You should have got it from the bugtracker administrator.");
        }
        this.certificate = certificate;
        this.passphrase = UiUtils.getPassword((Text)this.passphraseField, (String)this.passphrase);
        this.storePassphrase = this.storePassphraseCheckBox.getSelection();
    }

    public void dialogShowing() {
        super.dialogShowing();
        Text componentToFocus = this.certificate != null ? this.passphraseField : this.certificateTextField;
        componentToFocus.setFocus();
    }

    @Nullable
    public File getCertificate() {
        return this.certificate;
    }

    @Nullable
    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean isStorePassphrase() {
        return this.storePassphrase;
    }

    private void showFileChooser() {
        FileDialog fileDialog = new FileDialog(this.certificateTextField.getShell(), 4096);
        fileDialog.setFilterNames(new String[]{"Certificate Files"});
        fileDialog.setFilterExtensions(new String[]{"*.p12"});
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        UiUtils.setText((Text)this.certificateTextField, (String)fileName);
        this.certificateTextField.setFocus();
    }
}

