/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Enumeration;
import jdbm.RecordManager;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.ICacheEntry;
import jdbm.helper.ISerializationHandler;
import jdbm.helper.Serializer;
import jdbm.helper.WrappedRuntimeException;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.Location;

public class CacheRecordManager
implements RecordManager {
    protected RecordManager _recman;
    protected CachePolicy<Long, Object> _cache;
    protected boolean _lazyInsert = false;

    public CacheRecordManager(RecordManager recman, CachePolicy<Long, Object> cache) {
        if (recman == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        this._recman = recman;
        this._cache = cache;
        this._cache.addListener(new CacheListener());
    }

    @Override
    public RecordManager getRecordManager() {
        return this._recman;
    }

    @Override
    public RecordManager getBaseRecordManager() {
        return this._recman.getBaseRecordManager();
    }

    @Override
    public ISerializationHandler getSerializationHandler() {
        this.checkIfClosed();
        return this._recman.getSerializationHandler();
    }

    public CachePolicy<Long, Object> getCachePolicy() {
        return this._cache;
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, null);
    }

    @Override
    public synchronized long insert(Object obj, Serializer serializer) throws IOException {
        boolean isDirty;
        long recid;
        this.checkIfClosed();
        if (this._lazyInsert) {
            Location physRowId = new Location(0L, 0);
            recid = ((BaseRecordManager)this._recman)._logMgr.insert(physRowId).toLong();
            isDirty = true;
        } else {
            recid = this._recman.insert(obj, serializer);
            isDirty = false;
        }
        try {
            this._cache.put(new Long(recid), obj, isDirty, serializer);
        }
        catch (CacheEvictionException except) {
            throw new WrappedRuntimeException(except);
        }
        return recid;
    }

    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        this._recman.delete(recid);
        this._cache.remove(new Long(recid));
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, null);
    }

    @Override
    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        Long id = new Long(recid);
        try {
            this._cache.put(id, obj, true, serializer);
        }
        catch (CacheEvictionException except) {
            throw new IOException(except.getMessage());
        }
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, null);
    }

    @Override
    public synchronized Object fetch(long recid, Serializer serializer) throws IOException {
        this.checkIfClosed();
        Long id = new Long(recid);
        Object obj = this._cache.get(id);
        if (obj == null && (obj = this._recman.fetch(recid, serializer)) != null) {
            try {
                this._cache.put(id, obj, false, serializer);
            }
            catch (CacheEvictionException except) {
                throw new WrappedRuntimeException(except);
            }
        }
        return obj;
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.close();
        this._recman = null;
        this._cache = null;
    }

    @Override
    public synchronized int getRootCount() {
        this.checkIfClosed();
        return this._recman.getRootCount();
    }

    @Override
    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this._recman.getRoot(id);
    }

    @Override
    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this._recman.setRoot(id, rowid);
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._recman.rollback();
        this._cache.removeAll();
    }

    @Override
    public synchronized long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        return this._recman.getNamedObject(name);
    }

    @Override
    public synchronized void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        this._recman.setNamedObject(name, recid);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._recman == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }

    protected void updateCacheEntries() throws IOException {
        Enumeration<ICacheEntry<Long, Object>> enume = this._cache.entries();
        while (enume.hasMoreElements()) {
            ICacheEntry<Long, Object> entry = enume.nextElement();
            if (!entry.isDirty()) continue;
            long recid = entry.getKey();
            Object value = entry.getValue();
            this._recman.update(recid, value, entry.getSerializer());
            entry.setDirty(false);
        }
    }

    private final class CacheListener
    implements CachePolicyListener {
        private CacheListener() {
        }

        public void cacheObjectEvicted(Object key, Object obj, boolean dirty, Serializer ser) throws CacheEvictionException {
            if (dirty) {
                try {
                    CacheRecordManager.this._recman.update((Long)key, obj, ser);
                }
                catch (IOException except) {
                    throw new CacheEvictionException(except);
                }
            }
        }
    }
}

