/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import jdbm.RecordManager;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;
import jdbm.extser.IStreamSerializer;
import jdbm.extser.Stateless;
import jdbm.helper.FastIterator;
import jdbm.helper.IterationException;
import jdbm.htree.HashBucket;
import jdbm.htree.HashNode;

public final class HashDirectory<K, V>
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    static final int MAX_CHILDREN = 256;
    static final int BIT_SIZE = 8;
    static final int MAX_DEPTH = 3;
    private long[] _children;
    private byte _depth;
    private transient RecordManager _recman;
    private transient long _recid;

    public HashDirectory() {
    }

    HashDirectory(byte depth) {
        this._depth = depth;
        this._children = new long[256];
    }

    void setPersistenceContext(RecordManager recman, long recid) {
        this._recman = recman;
        this._recid = recid;
    }

    long getRecid() {
        return this._recid;
    }

    boolean isEmpty() {
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] == 0L) continue;
            return false;
        }
        return true;
    }

    V get(K key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            return dir.get(key);
        }
        HashBucket bucket = (HashBucket)node;
        return bucket.getValue(key);
    }

    V put(K key, V value) throws IOException {
        if (value == null) {
            return this.remove(key);
        }
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            long b_recid;
            HashBucket<K, V> bucket = new HashBucket<K, V>(this._depth + 1);
            Object existing = bucket.addElement(key, value);
            this._children[hash] = b_recid = this._recman.insert(bucket);
            this._recman.update(this._recid, this);
            return existing;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            return dir.put(key, value);
        }
        HashBucket bucket = (HashBucket)node;
        if (bucket.hasRoom()) {
            V existing = bucket.addElement(key, value);
            this._recman.update(child_recid, bucket);
            return existing;
        }
        if (this._depth == 3) {
            throw new RuntimeException("Cannot create deeper directory. Depth=" + this._depth);
        }
        HashDirectory<K, V> dir = new HashDirectory<K, V>((byte)(this._depth + 1));
        long dir_recid = this._recman.insert(dir);
        dir.setPersistenceContext(this._recman, dir_recid);
        this._children[hash] = dir_recid;
        this._recman.update(this._recid, this);
        this._recman.delete(child_recid);
        ArrayList keys = bucket.getKeys();
        ArrayList values = bucket.getValues();
        int entries = keys.size();
        for (int i = 0; i < entries; ++i) {
            dir.put(keys.get(i), values.get(i));
        }
        return dir.put(key, value);
    }

    V remove(K key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            V existing = dir.remove(key);
            if (existing != null && dir.isEmpty()) {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this);
            }
            return existing;
        }
        HashBucket bucket = (HashBucket)node;
        Object existing = bucket.removeElement(key);
        if (existing != null) {
            if (bucket.getElementCount() >= 1) {
                this._recman.update(child_recid, bucket);
            } else {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this);
            }
        }
        return existing;
    }

    private int hashCode(Object key) {
        int hashMask = this.hashMask();
        int hash = key.hashCode();
        hash &= hashMask;
        hash >>>= (3 - this._depth) * 8;
        return hash %= 256;
    }

    int hashMask() {
        int bits = 255;
        int hashMask = bits << (3 - this._depth) * 8;
        return hashMask;
    }

    FastIterator<K> keys() throws IOException {
        return new HDIterator(true);
    }

    FastIterator<V> values() throws IOException {
        return new HDIterator(false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this._depth);
        out.writeObject(this._children);
    }

    @Override
    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._depth = in.readByte();
        this._children = (long[])in.readObject();
    }

    static /* synthetic */ long[] access$102(HashDirectory x0, long[] x1) {
        x0._children = x1;
        return x1;
    }

    public class HDIterator
    extends FastIterator {
        private boolean _iterateKeys;
        private ArrayList _dirStack = new ArrayList();
        private ArrayList _childStack = new ArrayList();
        private HashDirectory _dir;
        private int _child;
        private Iterator _iter;

        HDIterator(boolean iterateKeys) throws IOException {
            this._dir = HashDirectory.this;
            this._child = -1;
            this._iterateKeys = iterateKeys;
            this.prepareNext();
        }

        public Object next() {
            Object next = null;
            if (this._iter != null && this._iter.hasNext()) {
                next = this._iter.next();
            } else {
                try {
                    this.prepareNext();
                }
                catch (IOException except) {
                    throw new IterationException(except);
                }
                if (this._iter != null && this._iter.hasNext()) {
                    return this.next();
                }
            }
            return next;
        }

        private void prepareNext() throws IOException {
            long child_recid = 0L;
            do {
                ++this._child;
                if (this._child >= 256) {
                    if (this._dirStack.isEmpty()) {
                        return;
                    }
                    this._dir = (HashDirectory)this._dirStack.remove(this._dirStack.size() - 1);
                    this._child = (Integer)this._childStack.remove(this._childStack.size() - 1);
                    continue;
                }
                child_recid = this._dir._children[this._child];
            } while (child_recid == 0L);
            if (child_recid == 0L) {
                throw new Error("child_recid cannot be 0");
            }
            HashNode node = (HashNode)HashDirectory.this._recman.fetch(child_recid);
            if (node instanceof HashDirectory) {
                this._dirStack.add(this._dir);
                this._childStack.add(new Integer(this._child));
                this._dir = (HashDirectory)node;
                this._child = -1;
                this._dir.setPersistenceContext(HashDirectory.this._recman, child_recid);
                this.prepareNext();
            } else {
                HashBucket bucket = (HashBucket)node;
                this._iter = this._iterateKeys ? bucket.getKeys().iterator() : bucket.getValues().iterator();
            }
        }
    }

    public static class Serializer0
    implements IStreamSerializer,
    Stateless {
        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            HashDirectory tmp = (HashDirectory)obj;
            out.writeByte(tmp._depth);
            out.serialize(tmp._children);
        }

        @Override
        public Object deserialize(DataInput in, Object obj) throws IOException {
            HashDirectory tmp = (HashDirectory)obj;
            tmp._depth = in.readByte();
            HashDirectory.access$102(tmp, (long[])in.deserialize());
            return tmp;
        }
    }
}

