/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.maps;

import java.util.NoSuchElementException;
import jdbm.helper.maps.NoSuchMappingException;

public class Exceptions {
    public static void nullArgument(String name) throws NullPointerException {
        throw new NullPointerException("The specified " + name + " is null");
    }

    public static void negativeArgument(String name, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException(name + " cannot be negative: " + String.valueOf(value));
    }

    public static void negativeOrZeroArgument(String name, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException(name + " must be a positive value: " + String.valueOf(value));
    }

    public static void endOfIterator() throws NoSuchElementException {
        throw new NoSuchElementException("Attempt to iterate past iterator's last element.");
    }

    public static void startOfIterator() throws NoSuchElementException {
        throw new NoSuchElementException("Attempt to iterate past iterator's first element.");
    }

    public static void noElementToRemove() throws IllegalStateException {
        throw new IllegalStateException("Attempt to remove element from iterator that has no current element.");
    }

    public static void noElementToGet() throws IllegalStateException {
        throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
    }

    public static void noElementToSet() throws IllegalStateException {
        throw new IllegalStateException("Attempt to set element in iterator that has no current element.");
    }

    public static void noLastElement() throws IllegalStateException {
        throw new IllegalStateException("No value to return. Call containsKey() first.");
    }

    public static void noSuchMapping(Object key) throws NoSuchMappingException {
        throw new NoSuchMappingException("No such key in map: " + String.valueOf(key));
    }

    public static void unsupported(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Attempt to invoke unsupported operation: " + name);
    }

    public static void cloning() throws RuntimeException {
        throw new RuntimeException("Clone is not supported");
    }
}

