/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import jdbm.RecordManager;
import jdbm.btree.BPage;
import jdbm.btree.BTree;
import jdbm.extser.AbstractExtensibleSerializer;
import jdbm.extser.IExtensibleSerializer;
import jdbm.extser.ISerializer;
import jdbm.extser.LongPacker;
import jdbm.helper.DefaultSerializer;
import jdbm.htree.HashBucket;
import jdbm.htree.HashDirectory;
import jdbm.strings.StringTable;

public class ExtensibleSerializer
extends AbstractExtensibleSerializer {
    private static final long serialVersionUID = 1L;
    private transient RecordManager m_recman;
    private transient long m_recid;

    public RecordManager getRecordManager() {
        return this.m_recman;
    }

    public long getRecid() {
        return this.m_recid;
    }

    public static ExtensibleSerializer createInstance(RecordManager recman) throws IOException {
        ExtensibleSerializer ser = new ExtensibleSerializer();
        ser.m_recman = recman;
        ser.m_recid = recman.insert(ser, DefaultSerializer.INSTANCE);
        ser.registerSerializers();
        return ser;
    }

    public static ExtensibleSerializer load(RecordManager recman, long recid) throws IOException {
        ExtensibleSerializer ser = (ExtensibleSerializer)recman.fetch(recid, DefaultSerializer.INSTANCE);
        ser.m_recman = recman;
        ser.m_recid = recid;
        return ser;
    }

    @Override
    protected synchronized void update() {
        try {
            this.m_recman.update(this.m_recid, this, DefaultSerializer.INSTANCE);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ISerializer getSerializer(long serializerId) {
        try {
            return (ISerializer)this.getRecordManager().fetch(serializerId);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void setupSerializers() {
        super.setupSerializers();
        this._registerClass(BTree.class, BTree.Serializer0.class, (short)0);
        this._registerClass(BPage.class, BPage.Serializer0.class, (short)0);
        this._registerClass(HashDirectory.class, HashDirectory.Serializer0.class, (short)0);
        this._registerClass(HashBucket.class, HashBucket.Serializer0.class, (short)0);
        this._registerClass(StringTable.class, StringTable.Serializer0.class, (short)0);
        this._registerClass(HashMap.class);
    }

    @Override
    public AbstractExtensibleSerializer.DataOutputStream getDataOutputStream(long recid, ByteArrayOutputStream baos) throws IOException {
        return new MyDataOutputStream(recid, this, baos);
    }

    @Override
    public AbstractExtensibleSerializer.DataInputStream getDataInputStream(long recid, ByteArrayInputStream bais) throws IOException {
        return new MyDataInputStream(recid, this, bais);
    }

    public static class MyDataInputStream
    extends AbstractExtensibleSerializer.DataInputStream {
        protected MyDataInputStream(long recid, IExtensibleSerializer serializer, ByteArrayInputStream is) throws IOException {
            super(recid, serializer, is);
        }

        @Override
        public long readPackedOId() throws IOException {
            return LongPacker.unpackLong(this);
        }
    }

    public static class MyDataOutputStream
    extends AbstractExtensibleSerializer.DataOutputStream {
        protected MyDataOutputStream(long recid, IExtensibleSerializer serializer, ByteArrayOutputStream out) throws IOException {
            super(recid, serializer, out);
        }

        @Override
        public int writePackedOId(long oid) throws IOException {
            return LongPacker.packLong(this, oid);
        }
    }
}

