/*
 * Decompiled with CFR 0.152.
 */
package jdbm.extser.profiler;

import java.io.PrintStream;
import jdbm.extser.AbstractExtensibleSerializer;

public abstract class Statistics {
    private final AbstractExtensibleSerializer serializer;
    public long nread;
    public long bytesRead;
    public long nwritten;
    public long bytesWritten;

    public AbstractExtensibleSerializer getSerializer() {
        return this.serializer;
    }

    public Statistics(AbstractExtensibleSerializer serializer) {
        this.serializer = serializer;
    }

    public void read(int nbytes) {
        ++this.nread;
        this.bytesRead += (long)nbytes;
    }

    public void write(int nbytes) {
        ++this.nwritten;
        this.bytesWritten += (long)nbytes;
    }

    public void writeOn(PrintStream ps) {
        long avgPerRead = this.nread == 0L ? 0L : this.bytesRead / this.nread;
        long avgPerWrite = this.nwritten == 0L ? 0L : this.bytesWritten / this.nwritten;
        ps.println("read(" + this.nread + "," + this.bytesRead + "," + avgPerRead + ")" + ", write(" + this.nwritten + "," + this.bytesWritten + "," + avgPerWrite + ")");
    }

    public void reset() {
        this.bytesRead = 0L;
        this.nread = 0L;
        this.bytesWritten = 0L;
        this.nwritten = 0L;
    }
}

