/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import jdbm.RecordManager;
import jdbm.btree.BPage;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;
import jdbm.extser.IStreamSerializer;
import jdbm.extser.Stateless;
import jdbm.helper.ExtensibleSerializerSingleton;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.helper.compression.CompressionProvider;

public class BTree<K extends Serializable, V extends Serializable>
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    private transient RecordManager _recman;
    private transient long _recid;
    protected Comparator<K> _comparator;
    protected Serializer _keySerializer;
    protected Serializer _valueSerializer;
    private int _height;
    private transient long _root;
    protected int _pageSize;
    protected long _entries;
    protected CompressionProvider _keyCompressionProvider;
    private transient BPage<K, V> _bpageSerializer;

    public static <K extends Serializable, V extends Serializable> BTree<K, V> createInstance(RecordManager recman, Comparator<K> comparator) throws IOException {
        return BTree.createInstance(recman, comparator, null, null, 16);
    }

    public static <K extends Serializable, V extends Serializable> BTree<K, V> createInstance(RecordManager recman, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        return BTree.createInstance(recman, comparator, keySerializer, valueSerializer, 16);
    }

    public static <K extends Serializable, V extends Serializable> BTree<K, V> createInstance(RecordManager recman, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer, int pageSize) throws IOException {
        if (recman == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 'comparator' is null");
        }
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'comparator' must be serializable");
        }
        if (keySerializer != null && !(keySerializer instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'keySerializer' must be serializable");
        }
        if (valueSerializer != null && !(valueSerializer instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'valueSerializer' must be serializable");
        }
        if ((pageSize & 1) != 0) {
            throw new IllegalArgumentException("Argument 'pageSize' must be even");
        }
        BTree<K, V> btree = new BTree<K, V>();
        btree._recman = recman;
        btree._comparator = comparator;
        btree._keySerializer = keySerializer;
        btree._valueSerializer = valueSerializer;
        btree._pageSize = pageSize;
        btree._bpageSerializer = new BPage();
        btree._bpageSerializer._btree = btree;
        btree._recid = recman.insert(btree);
        btree._bpageSerializer._btreeId = btree.getRecid();
        btree._keyCompressionProvider = null;
        return btree;
    }

    public static <K extends Serializable, V extends Serializable> BTree<K, V> load(RecordManager recman, long recid) throws IOException {
        BTree btree = (BTree)recman.fetch(recid);
        btree._recid = recid;
        btree._recman = recman;
        btree._bpageSerializer = new BPage();
        btree._bpageSerializer._btree = btree;
        btree._bpageSerializer._btreeId = recid;
        return btree;
    }

    public void setKeyCompressionProvider(CompressionProvider provider) {
        if (this._entries != 0L) {
            throw new IllegalArgumentException("You can't change the key compression provider once the BTree is populated");
        }
        this._keyCompressionProvider = provider;
    }

    public CompressionProvider getKeyCompressionProvider() {
        return this._keyCompressionProvider;
    }

    public synchronized V insert(K key, V value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' is null");
        }
        BPage<Object, Object> rootPage = this.getRoot();
        if (rootPage == null) {
            rootPage = new BPage<K, V>(this, key, value);
            this._root = rootPage._recid;
            this._height = 1;
            this._entries = 1L;
            this._recman.update(this._recid, this);
            return null;
        }
        BPage.InsertResult<K, V> insert = rootPage.insert(this._height, key, value, replace);
        boolean dirty = false;
        if (insert._overflow != null) {
            rootPage = new BPage(this, rootPage, insert._overflow);
            this._root = rootPage._recid;
            ++this._height;
            dirty = true;
        }
        if (insert._existing == null) {
            ++this._entries;
            dirty = true;
        }
        if (dirty) {
            this._recman.update(this._recid, this);
        }
        return insert._existing;
    }

    public synchronized V remove(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        boolean dirty = false;
        BPage.RemoveResult<V> remove = rootPage.remove(this._height, key);
        if (remove._underflow && rootPage.isEmpty()) {
            --this._height;
            dirty = true;
            this._recman.delete(this._root);
            this._root = this._height == 0 ? 0L : rootPage.childBPage((int)(this._pageSize - 1))._recid;
        }
        if (remove._value != null) {
            --this._entries;
            dirty = true;
        }
        if (dirty) {
            this._recman.update(this._recid, this);
        }
        return (V)((Serializable)remove._value);
    }

    public synchronized V find(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        Tuple<Object, Object> tuple = new Tuple<Object, Object>(null, null);
        TupleBrowser<Object, Object> browser = rootPage.find(this._height, key);
        if (browser.getNext(tuple)) {
            if (this._comparator.compare(key, tuple.getKey()) != 0) {
                return null;
            }
            return (V)((Serializable)tuple.getValue());
        }
        return null;
    }

    public synchronized Tuple<K, V> findGreaterOrEqual(K key) throws IOException {
        if (key == null) {
            return null;
        }
        Tuple<Object, Object> tuple = new Tuple<Object, Object>(null, null);
        TupleBrowser<Object, Object> browser = this.browse(key);
        if (browser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    public synchronized TupleBrowser<K, V> browse() throws IOException {
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return new EmptyBrowser();
        }
        TupleBrowser<K, V> browser = rootPage.findFirst();
        return browser;
    }

    public synchronized TupleBrowser<K, V> browse(K key) throws IOException {
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return new EmptyBrowser();
        }
        TupleBrowser<K, V> browser = rootPage.find(this._height, key);
        return browser;
    }

    public synchronized void delete() throws IOException {
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage != null) {
            rootPage.delete();
        }
        this._recman.delete(this._recid);
    }

    public synchronized int size() {
        if (this._entries > Integer.MAX_VALUE) {
            throw new RuntimeException("Size exceeds Integer.");
        }
        return (int)this._entries;
    }

    public synchronized long entryCount() {
        return this._entries;
    }

    public long getRecid() {
        return this._recid;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public int getHeight() {
        return this._height;
    }

    public Comparator<K> getComparator() {
        return this._comparator;
    }

    public Serializer getKeySerializer() {
        return this._keySerializer;
    }

    public Serializer getValueSerializer() {
        return this._valueSerializer;
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this._valueSerializer = valueSerializer;
    }

    protected BPage<K, V> getRoot() throws IOException {
        if (this._root == 0L) {
            return null;
        }
        BPage<K, V> root = this._fetch(this._root, this._bpageSerializer);
        root._recid = this._root;
        root._btree = this;
        root._btreeId = this.getRecid();
        return root;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._comparator = (Comparator)in.readObject();
        this._keySerializer = (Serializer)in.readObject();
        this._valueSerializer = (Serializer)in.readObject();
        this._height = in.readInt();
        this._root = in.readLong();
        this._pageSize = in.readInt();
        int tmp = in.readInt();
        this._entries = tmp == -1 ? in.readLong() : (long)tmp;
        try {
            this._keyCompressionProvider = (CompressionProvider)in.readObject();
        }
        catch (EOFException e) {
            this._keyCompressionProvider = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._comparator);
        out.writeObject(this._keySerializer);
        out.writeObject(this._valueSerializer);
        out.writeInt(this._height);
        out.writeLong(this._root);
        out.writeInt(this._pageSize);
        if (this._entries < Integer.MAX_VALUE) {
            out.writeInt((int)this._entries);
        } else {
            out.writeInt(-1);
            out.writeLong(this._entries);
        }
        out.writeObject(this._keyCompressionProvider);
    }

    public void dump(PrintStream out) throws IOException {
        BPage<K, V> root = this.getRoot();
        if (root != null) {
            root.dump(out, 0);
            root.dumpRecursive(out, this._height, 0);
        }
    }

    void dumpChildPageRecIDs(List<Long> out) throws IOException {
        BPage<K, V> root = this.getRoot();
        if (root != null) {
            out.add(new Long(root._recid));
            root.dumpChildPageRecIDs(out, this._height);
        }
    }

    protected boolean isExtensibleSerializer() {
        return this._recman.getSerializationHandler() instanceof ExtensibleSerializerSingleton;
    }

    long _insert(BPage<K, V> bpage, Serializer ser) throws IOException {
        return this.isExtensibleSerializer() ? this._recman.insert(bpage) : this._recman.insert(bpage, ser);
    }

    BPage<K, V> _fetch(long recid, Serializer ser) throws IOException {
        return (BPage)(this.isExtensibleSerializer() ? this._recman.fetch(recid) : this._recman.fetch(recid, ser));
    }

    void _update(long recid, BPage<K, V> bpage, Serializer ser) throws IOException {
        if (this.isExtensibleSerializer()) {
            this._recman.update(recid, bpage);
        } else {
            this._recman.update(recid, bpage, ser);
        }
    }

    void _delete(long recid) throws IOException {
        this._recman.delete(recid);
    }

    static class EmptyBrowser<K, V>
    extends TupleBrowser<K, V> {
        EmptyBrowser() {
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) {
            return false;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) {
            return false;
        }
    }

    public static class Serializer0
    implements IStreamSerializer,
    Stateless {
        private static final long serialVersionUID = 8346217765956148885L;

        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            BTree tmp = (BTree)obj;
            out.writePackedInt(tmp._height);
            out.writePackedInt(tmp._pageSize);
            out.writePackedLong(tmp._root);
            out.writePackedLong(tmp._entries);
            out.serialize(tmp._comparator);
            out.serialize(tmp._keySerializer);
            out.serialize(tmp._valueSerializer);
            out.serialize(tmp._keyCompressionProvider);
        }

        @Override
        public Object deserialize(DataInput in, Object obj) throws IOException {
            BTree tmp = (BTree)obj;
            tmp._height = in.readPackedInt();
            tmp._pageSize = in.readPackedInt();
            tmp._root = in.readPackedLong();
            tmp._entries = in.readPackedLong();
            tmp._comparator = (Comparator)in.deserialize();
            tmp._keySerializer = (Serializer)in.deserialize();
            tmp._valueSerializer = (Serializer)in.deserialize();
            tmp._keyCompressionProvider = (CompressionProvider)in.deserialize();
            return tmp;
        }
    }
}

