/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.committemplate;

import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitPacket;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitWorkflowServices;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterCommitWorkflow;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitWorkflow;
import com.syntevo.plugin.committemplate.CommitTemplatePlugin;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.types.Revision;

final class CommitTemplateCommitWorkflow
extends FilterCommitWorkflow {
    private static final String COMMIT_TEMPLATE_PROPERTY_NAME = System.getProperty("commitTemplate.svnPropertyName", "tsvn:logtemplate");
    private final CommitWorkflowServices services;

    public CommitTemplateCommitWorkflow(ICommitWorkflow baseWorkflow, CommitWorkflowServices services) {
        super(baseWorkflow);
        this.services = services;
    }

    public Set<CommitPacket> prepareForPacketPhases(Set<CommitPacket> packets) {
        for (CommitPacket packet : packets) {
            if (packet.getMessage() != null) continue;
            packet.setMessage(this.getTemplateMessage(packet.getCommitRoot().getFile()));
        }
        return super.prepareForPacketPhases(packets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTemplateMessage(File root) {
        String propertyValue;
        byte[] propertyData;
        ISVNClient svnClient = this.services.getClients().createClient();
        try {
            propertyData = svnClient.propertyGet(root.getAbsolutePath(), COMMIT_TEMPLATE_PROPERTY_NAME, Revision.WORKING, Revision.WORKING);
        }
        catch (SubversionException ex) {
            String string;
            try {
                CommitTemplatePlugin.LOGGER.error("Failed to load commit message template by reading the property " + COMMIT_TEMPLATE_PROPERTY_NAME + " from " + root, (Throwable)ex);
                string = null;
            }
            catch (Throwable throwable) {
                try {
                    svnClient.dispose();
                    throw throwable;
                }
                catch (SubversionException ex2) {
                    CommitTemplatePlugin.LOGGER.error("Failed to instantiate client connection", (Throwable)ex2);
                    return null;
                }
            }
            svnClient.dispose();
            return string;
        }
        svnClient.dispose();
        if (propertyData == null || propertyData.length == 0) {
            return null;
        }
        try {
            propertyValue = new String(propertyData, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            CommitTemplatePlugin.LOGGER.warn("Failed to decode property " + COMMIT_TEMPLATE_PROPERTY_NAME + " value set on " + root, (Throwable)ex);
            return null;
        }
        return propertyValue;
    }
}

