from mercurial import copies, merge
import os

def normalize(files):
    # normalized = set()
    #
    # separator = '\\' if os.name == 'win' else '/'
    # for file in files:
    #     normalized.add(file.replace(separator, '/'))

    return set(files)


def collectparents(files, parents, knownparents):
    for f in files:
        lastindex = f.rfind('/')
        while lastindex >= 0:
            f = f[0:lastindex]
            lastindex = f.rfind('/')
            if f in knownparents:
                break
            parents.add(f)
            knownparents.add(f)


def sgstatus(ui, repo):
    ds = repo.dirstate

    orgignore = ds._ignore
    ignoreddirs = set()
    ignoredfiles = set()

    def ignore(x):
        ign = orgignore(x)
        if ign:
            if os.path.isdir(ds._join(x)):
                ignoreddirs.add(x)
            else:
                ignoredfiles.add(x)
        return ign

    ds._ignore = ignore

    p1 = ds.p1()
    r = repo[p1].status(None, None, False, True, True, False)
    srcpaths = copies.pathcopies(repo['.'], repo[None])

    clean = normalize(r.clean)
    modified = normalize(r.modified)
    added = normalize(r.added)
    removed = normalize(r.removed)
    deleted = normalize(r.deleted)
    unknown = normalize(r.unknown)

    tracked = clean.union(modified).union(added).union(removed)

    allparents = set()
    trackedparents = set()
    collectparents(tracked, trackedparents, allparents)

    deletedparents = set()
    possiblydeletedparents = set()
    collectparents(deleted, possiblydeletedparents, allparents)

    for p in possiblydeletedparents:
        if os.path.isdir(ds._join(p)):
            trackedparents.add(p)
        else:
            deletedparents.add(p)

    ignoredparents = set()
    collectparents(ignoredfiles.union(ignoreddirs), ignoredparents, allparents)
    ignoredparents = ignoredparents.difference(ignoreddirs)

    unknownparents = set()
    collectparents(unknown, unknownparents, allparents)

    all = tracked.union(deleted).union(ignoredfiles).union(ignoreddirs).union(unknown)
    all = all.union(deletedparents).union(trackedparents).union(ignoredparents).union(unknownparents)
    all = list(all)
    all.sort()

    assert not '' in all

    conflicts = set()
    merged = set()
    mergestate = merge.mergestate(repo)
    if mergestate.active:
        conflicts = conflicts.union(set(mergestate.unresolved()))
        merged = set(mergestate.files()).difference(conflicts)

    ui.write('D\tC\t\n')

    for path in all:
        if path in conflicts:
            kind = 'F'
            status = 'X'
        elif path in merged:
            kind = 'F'
            status = 'Y'
        elif path in clean:
            kind = 'F'
            status = 'C'
        elif path in modified:
            kind = 'F'
            status = 'M'
        elif path in added:
            kind = 'F'
            status = 'A'
        elif path in removed:
            kind = 'F'
            status = 'R'
        elif path in deleted:
            kind = 'F'
            status = '!'
        elif path in unknown:
            kind = 'F'
            status = '?'
        elif path in ignoredfiles:
            kind = 'F'
            status = 'I'
        elif path in trackedparents:
            kind = 'D'
            status = 'C'
        elif path in deletedparents:
            kind = 'D'
            status = '!'
        elif path in ignoreddirs:
            kind = 'D'
            status = 'I'
        elif path in ignoredparents:
            kind = 'D'
            status = 'C'
        elif path in unknownparents:
            kind = 'D'
            status = '?'
        else:
            raise AssertionError('Unknown status for ' + path)

        srcpath = None
        if kind == 'F' and path in srcpaths is not None:
            status = 'O'
            srcpath = srcpaths[path]

        ui.write(kind, '\t', status, '\t', path, '\n')
        if srcpath is not None:
            ui.write(' ', '\t', ' ', '\t', srcpath, '\n')

cmdtable = {
    'sgstatus': (sgstatus, [], '')
}
