from mercurial.node import hex

def sggetcommitinfo(ui, repo, fname):
    with open(fname) as file:
        shas = [line.strip() for line in file.readlines()]
        file.close()

    changelog = repo.changelog
    for sha in shas:
        try:
            ctx = repo[changelog.lookup(sha)]
            p1Node = hex(ctx.parents()[0].node()) if len(ctx.parents()) >= 1 else ''
            p1Rev = ctx.parents()[0].rev() if len(ctx.parents()) >= 1 else '-1'
            p2Node = hex(ctx.parents()[1].node()) if len(ctx.parents()) >= 2 else ''
            p2Rev = ctx.parents()[1].rev() if len(ctx.parents()) >= 2 else '-1'
            ui.write("commit\t", hex(ctx.node()), '\t', ctx.rev(), '\t', ctx.phase(), '\t', ctx.user(),
                     '\t%d %d' % ctx.date(), '\t',
                     ctx.branch(), '\t', p1Node, '\t', p1Rev, '\t', p2Node, '\t', p2Rev, '\t\0', ctx.description().rstrip(), '\0\n')
        except LookupError:
            pass

    ui.write('eof\n')

cmdtable = {
    'sggetcommitinfo': (sggetcommitinfo, [], 'FILE')
}
