/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigIllegalValueException;
import org.eclipse.jgit.lib.CoreConfig;

public class WorkingTreeOptions {
    public static final Config.SectionParser<WorkingTreeOptions> KEY = new Config.SectionParser<WorkingTreeOptions>(){

        @Override
        public WorkingTreeOptions parse(Config cfg) throws ConfigIllegalValueException {
            return new WorkingTreeOptions(cfg);
        }
    };
    private final boolean fileMode;
    private final CoreConfig.AutoCRLF autoCRLF;
    private final CoreConfig.CheckStat checkStat;
    private final CoreConfig.SymLinks symlinks;
    private final CoreConfig.HideDotFiles hideDotFiles;

    private WorkingTreeOptions(Config rc) throws ConfigIllegalValueException {
        this.fileMode = rc.getBoolean("core", "filemode", true);
        this.autoCRLF = rc.getEnum("core", null, "autocrlf", CoreConfig.AutoCRLF.FALSE);
        this.checkStat = rc.getEnum("core", null, "checkstat", CoreConfig.CheckStat.DEFAULT);
        this.symlinks = rc.getEnum("core", null, "symlinks", CoreConfig.SymLinks.TRUE);
        this.hideDotFiles = rc.getEnum("core", null, "hidedotfiles", CoreConfig.HideDotFiles.DOTGITONLY);
    }

    public boolean isFileMode() {
        return this.fileMode;
    }

    public CoreConfig.AutoCRLF getAutoCRLF() {
        return this.autoCRLF;
    }

    public CoreConfig.CheckStat getCheckStat() {
        return this.checkStat;
    }

    public CoreConfig.SymLinks getSymLinks() {
        return this.symlinks;
    }

    public CoreConfig.HideDotFiles getHideDotFiles() {
        return this.hideDotFiles;
    }
}

