/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefNotAdvertisedException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigIllegalValueException;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;

public class PullCommand
extends TransportCommand<PullCommand, PullResult> {
    private static final String DOT = ".";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private PullRebaseMode pullRebaseMode = null;
    private String remote;
    private String remoteBranchName;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    protected PullCommand(Repository repo) {
        super(repo);
    }

    public PullCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public PullCommand setRebase(boolean useRebase) {
        this.checkCallable();
        this.pullRebaseMode = useRebase ? PullRebaseMode.REBASE : PullRebaseMode.NO_REBASE;
        return this;
    }

    @Override
    public PullResult call() throws GitAPIException, WrongRepositoryStateException, InvalidConfigurationException, DetachedHeadException, InvalidRemoteException, CanceledException, RefNotFoundException, RefNotAdvertisedException, NoHeadException, TransportException {
        PullResult result;
        ObjectId commitToMerge;
        OperationResult fetchRes;
        String remoteUri;
        boolean isRemote;
        StoredConfig repoConfig;
        String branchName;
        this.checkCallable();
        this.monitor.beginTask(JGitText.get().pullTaskName, 2);
        try {
            String fullBranch = this.repo.getFullBranch();
            if (fullBranch == null) {
                throw new NoHeadException(JGitText.get().pullOnRepoWithoutHEADCurrentlyNotSupported);
            }
            if (!fullBranch.startsWith("refs/heads/")) {
                throw new DetachedHeadException();
            }
            branchName = fullBranch.substring("refs/heads/".length());
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
        }
        if (!this.repo.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotPullOnARepoWithState, this.repo.getRepositoryState().name()));
        }
        try {
            repoConfig = this.repo.getConfig();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.remote == null) {
            this.remote = repoConfig.getString("branch", branchName, "remote");
        }
        if (this.remote == null) {
            this.remote = "origin";
        }
        if (this.remoteBranchName == null) {
            this.remoteBranchName = repoConfig.getString("branch", branchName, "merge");
        }
        if (this.pullRebaseMode == null) {
            try {
                this.pullRebaseMode = PullCommand.getRebaseMode(branchName, repoConfig);
            }
            catch (ConfigIllegalValueException ex) {
                throw new GitAPIException(ex.getMessage(), ex){};
            }
        }
        if (this.remoteBranchName == null) {
            this.remoteBranchName = branchName;
        }
        boolean bl = isRemote = !this.remote.equals(DOT);
        if (isRemote) {
            remoteUri = repoConfig.getString("remote", this.remote, "url");
            if (remoteUri == null) {
                String missingKey = "remote." + this.remote + DOT + "url";
                throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().missingConfigurationForKey, missingKey));
            }
            if (this.monitor.isCancelled()) {
                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
            }
            FetchCommand fetch = new FetchCommand(this.repo);
            fetch.setRemote(this.remote);
            fetch.setProgressMonitor(this.monitor);
            this.configure(fetch);
            fetchRes = fetch.call();
        } else {
            remoteUri = JGitText.get().localRepository;
            fetchRes = null;
        }
        this.monitor.update(1);
        if (this.monitor.isCancelled()) {
            throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
        }
        if (isRemote) {
            Ref r = null;
            if (fetchRes != null && (r = fetchRes.getAdvertisedRef(this.remoteBranchName)) == null) {
                r = fetchRes.getAdvertisedRef("refs/heads/" + this.remoteBranchName);
            }
            if (r == null) {
                throw new RefNotAdvertisedException(MessageFormat.format(JGitText.get().couldNotGetAdvertisedRef, this.remote, this.remoteBranchName));
            }
            commitToMerge = r.getObjectId();
        } else {
            try {
                commitToMerge = this.repo.resolve(this.remoteBranchName);
                if (commitToMerge == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.remoteBranchName));
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
            }
        }
        String upstreamName = MessageFormat.format(JGitText.get().upstreamBranchName, Repository.shortenRefName(this.remoteBranchName), remoteUri);
        if (this.pullRebaseMode.rebase) {
            RebaseCommand rebase = new RebaseCommand(this.repo);
            RebaseResult rebaseRes = rebase.setUpstream(commitToMerge).setUpstreamName(upstreamName).setProgressMonitor(this.monitor).setOperation(RebaseCommand.Operation.BEGIN).setStrategy(this.strategy).setPreserveMerges(this.pullRebaseMode.preserveMerges).call();
            result = new PullResult((FetchResult)fetchRes, this.remote, rebaseRes);
        } else {
            MergeCommand merge = new MergeCommand(this.repo);
            merge.include(upstreamName, commitToMerge);
            merge.setStrategy(this.strategy);
            MergeResult mergeRes = merge.call();
            this.monitor.update(1);
            result = new PullResult((FetchResult)fetchRes, this.remote, mergeRes);
        }
        this.monitor.endTask();
        return result;
    }

    public PullCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public PullCommand setRemoteBranchName(String remoteBranchName) {
        this.checkCallable();
        this.remoteBranchName = remoteBranchName;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getRemoteBranchName() {
        return this.remoteBranchName;
    }

    public PullCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    private static PullRebaseMode getRebaseMode(String branchName, Config config) throws ConfigIllegalValueException {
        PullRebaseMode mode = (PullRebaseMode)config.getEnum(PullRebaseMode.values(), "pull", null, "rebase", PullRebaseMode.NO_REBASE);
        mode = (PullRebaseMode)config.getEnum(PullRebaseMode.values(), "branch", branchName, "rebase", mode);
        return mode;
    }

    private static enum PullRebaseMode implements Config.ConfigEnum
    {
        REBASE_PRESERVE("preserve", true, true),
        REBASE("true", true, false),
        NO_REBASE("false", false, false);

        private final String configValue;
        private final boolean rebase;
        private final boolean preserveMerges;

        private PullRebaseMode(String configValue, boolean rebase, boolean preserveMerges) {
            this.configValue = configValue;
            this.rebase = rebase;
            this.preserveMerges = preserveMerges;
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }

        @Override
        public boolean matchConfigValue(String in) {
            return in.equals(this.configValue);
        }
    }
}

