/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.WebResultSet;
import ca.sqlpower.util.Cache;
import ca.sqlpower.util.LeastRecentlyUsedCache;
import ca.sqlpower.util.SynchronizedCache;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DelayedWebResultSet
extends WebResultSet {
    private static Cache resultCache = null;
    private static Object resultCacheMutex = new Object();
    private static final Logger logger = Logger.getLogger(DelayedWebResultSet.class);
    protected int givenColCount;
    protected Connection con;
    protected boolean cacheEnabled;
    protected long queryExecuteTime;
    protected long resultPopulateTime;
    protected boolean fromCache;
    protected long totalExecuteTime;
    protected int maxRows;

    public DelayedWebResultSet(int cols, String query) {
        this(cols, query, true);
    }

    public DelayedWebResultSet(int cols, String query, boolean useCache) {
        this.sqlQuery = query;
        this.givenColCount = cols;
        this.cacheEnabled = useCache;
        this.con = null;
        this.initMembers(cols);
    }

    protected DelayedWebResultSet() {
        this.sqlQuery = null;
        this.givenColCount = 0;
        this.cacheEnabled = true;
        this.con = null;
    }

    public void execute(Connection con) throws IllegalStateException, SQLException {
        try {
            this.execute(con, true);
        }
        catch (SQLException e) {
            System.out.println("dwrs caught sqlexception from query: " + this.sqlQuery);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Connection con, boolean closeOldRS) throws IllegalStateException, SQLException {
        long startTime = System.currentTimeMillis();
        this.con = con;
        this.fromCache = false;
        ResultSet newRS = null;
        if (this.cacheEnabled) {
            String cacheKey = this.sqlQuery + "&" + con.getMetaData().getURL() + "&" + con.getMetaData().getUserName();
            CachedRowSet results = this.getCachedResult(cacheKey);
            if (results != null) {
                logger.debug((Object)("cache hit, key: " + cacheKey));
                closeOldRS = false;
                this.queryExecuteTime = 0L;
                this.resultPopulateTime = 0L;
                this.fromCache = true;
            } else {
                logger.debug((Object)("cache miss, key: " + cacheKey));
                long queryStartTime = System.currentTimeMillis();
                Statement stmt = null;
                try {
                    stmt = con.createStatement();
                    stmt.setMaxRows(this.getMaxRows());
                    results = new CachedRowSet();
                    ResultSet rs = stmt.executeQuery(this.sqlQuery);
                    this.queryExecuteTime = System.currentTimeMillis() - queryStartTime;
                    results.populate(rs);
                    this.resultPopulateTime = System.currentTimeMillis() - queryStartTime - this.queryExecuteTime;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                logger.debug((Object)("adding results to cache, key: " + cacheKey));
                results = this.addResultsToCache(cacheKey, results);
            }
            newRS = results;
        } else {
            Statement stmt;
            if (closeOldRS && this.rs != null && (stmt = this.rs.getStatement()) != null) {
                stmt.close();
            }
            stmt = con.createStatement();
            stmt.setMaxRows(this.getMaxRows());
            long queryStartTime = System.currentTimeMillis();
            newRS = stmt.executeQuery(this.sqlQuery);
            this.queryExecuteTime = System.currentTimeMillis() - queryStartTime;
            this.resultPopulateTime = 0L;
        }
        this.applyResultSet(newRS, closeOldRS);
        this.columnCountSanityCheck();
        this.totalExecuteTime = System.currentTimeMillis() - startTime;
    }

    protected void columnCountSanityCheck() throws SQLException, IllegalStateException {
        if (this.getRsmd().getColumnCount() != this.givenColCount) {
            throw new IllegalStateException("The SQL query returned " + this.getRsmd().getColumnCount() + " columns, but the number of columns originally specified was " + this.givenColCount + ".");
        }
    }

    @Override
    public int getColumnCount() {
        return this.givenColCount;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean v) {
        this.cacheEnabled = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getResultCache() {
        if (resultCache == null) {
            Object object = resultCacheMutex;
            synchronized (object) {
                if (resultCache == null) {
                    resultCache = new SynchronizedCache(new LeastRecentlyUsedCache(100));
                }
            }
        }
        return resultCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache staticGetResultCache() {
        if (resultCache == null) {
            Object object = resultCacheMutex;
            synchronized (object) {
                if (resultCache == null) {
                    resultCache = new SynchronizedCache(new LeastRecentlyUsedCache(100));
                }
            }
        }
        return resultCache;
    }

    protected CachedRowSet addResultsToCache(String key, CachedRowSet results) throws SQLException {
        this.getResultCache().put(key, results);
        return results;
    }

    protected CachedRowSet getCachedResult(String key) throws SQLException {
        CachedRowSet results = (CachedRowSet)this.getResultCache().get(key);
        return results;
    }

    @Override
    public void close() throws SQLException {
        if (!this.cacheEnabled) {
            super.close();
        }
    }

    public boolean isEmpty() throws SQLException {
        if (!(this.rs instanceof CachedRowSet)) {
            throw new UnsupportedOperationException("Can't tell if result set is empty unless caching is enabled");
        }
        return ((CachedRowSet)this.rs).size() == 0;
    }

    public long getQueryExecuteTime() {
        return this.queryExecuteTime;
    }

    public long getResultPopulateTime() {
        return this.resultPopulateTime;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public long getTotalExecuteTime() {
        return this.totalExecuteTime;
    }

    public void setMaxRows(int v) {
        this.maxRows = v;
    }

    public int getMaxRows() {
        return this.maxRows;
    }
}

