/*
 * turtle.c	-*- C -*-
 * 
 * turtle graphics for BGI-compatible libraries
 * Tested with xbgi and grx
 * 
 * By Guido Gonzato <guido.gonzato at gmail.com>
 * January 2013
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "../graphics.h"

#include "turtle.h"

/* ----- */

static int t_x = 0, t_y = 0;           /* turtle coordinates */
static int t_heading = 0;              /* turtle heading */

static int t_show_turtle = T_FALSE;    /* draw the turtle? */
static int t_pen_down = T_TRUE;        /* draw? */
static int t_turtle_drawn = T_TRUE;    /* has the turtle been drawn? */
static int t_turtle_wrap = T_FALSE;    /* wrap around the window? */

static void draw_turtle (void);
static void undraw_turtle (void);

/* sine and cosine tables for polar graphics. The angle
 * starts at pi/2 and increases clockwise: -(angle-90)
 */

static double t_sin[360] =
{1.000000,  0.999848,  0.999391,  0.998630,  0.997564,  
  0.996195,  0.994522,  0.992546,  0.990268,  0.987688,  
  0.984808,  0.981627,  0.978148,  0.974370,  0.970296,  
  0.965926,  0.961262,  0.956305,  0.951057,  0.945519,  
  0.939693,  0.933580,  0.927184,  0.920505,  0.913545,  
  0.906308,  0.898794,  0.891007,  0.882948,  0.874620,  
  0.866025,  0.857167,  0.848048,  0.838671,  0.829038,  
  0.819152,  0.809017,  0.798636,  0.788011,  0.777146,  
  0.766044,  0.754710,  0.743145,  0.731354,  0.719340,  
  0.707107,  0.694658,  0.681998,  0.669131,  0.656059,  
  0.642788,  0.629320,  0.615661,  0.601815,  0.587785,  
  0.573576,  0.559193,  0.544639,  0.529919,  0.515038,  
  0.500000,  0.484810,  0.469472,  0.453990,  0.438371,  
  0.422618,  0.406737,  0.390731,  0.374607,  0.358368,  
  0.342020,  0.325568,  0.309017,  0.292372,  0.275637,  
  0.258819,  0.241922,  0.224951,  0.207912,  0.190809,  
  0.173648,  0.156434,  0.139173,  0.121869,  0.104528,  
  0.087156,  0.069756,  0.052336,  0.034899,  0.017452,  
  0.000000,  -0.017452,  -0.034899,  -0.052336,  -0.069756,  
  -0.087156,  -0.104528,  -0.121869,  -0.139173,  -0.156434,  
  -0.173648,  -0.190809,  -0.207912,  -0.224951,  -0.241922,  
  -0.258819,  -0.275637,  -0.292372,  -0.309017,  -0.325568,  
  -0.342020,  -0.358368,  -0.374607,  -0.390731,  -0.406737,  
  -0.422618,  -0.438371,  -0.453990,  -0.469472,  -0.484810,  
  -0.500000,  -0.515038,  -0.529919,  -0.544639,  -0.559193,  
  -0.573576,  -0.587785,  -0.601815,  -0.615661,  -0.629320,  
  -0.642788,  -0.656059,  -0.669131,  -0.681998,  -0.694658,  
  -0.707107,  -0.719340,  -0.731354,  -0.743145,  -0.754710,  
  -0.766044,  -0.777146,  -0.788011,  -0.798636,  -0.809017,  
  -0.819152,  -0.829038,  -0.838671,  -0.848048,  -0.857167,  
  -0.866025,  -0.874620,  -0.882948,  -0.891007,  -0.898794,  
  -0.906308,  -0.913545,  -0.920505,  -0.927184,  -0.933580,  
  -0.939693,  -0.945519,  -0.951057,  -0.956305,  -0.961262,  
  -0.965926,  -0.970296,  -0.974370,  -0.978148,  -0.981627,  
  -0.984808,  -0.987688,  -0.990268,  -0.992546,  -0.994522,  
  -0.996195,  -0.997564,  -0.998630,  -0.999391,  -0.999848,  
  -1.000000,  -0.999848,  -0.999391,  -0.998630,  -0.997564,  
  -0.996195,  -0.994522,  -0.992546,  -0.990268,  -0.987688,  
  -0.984808,  -0.981627,  -0.978148,  -0.974370,  -0.970296,  
  -0.965926,  -0.961262,  -0.956305,  -0.951057,  -0.945519,  
  -0.939693,  -0.933580,  -0.927184,  -0.920505,  -0.913545,  
  -0.906308,  -0.898794,  -0.891007,  -0.882948,  -0.874620,  
  -0.866025,  -0.857167,  -0.848048,  -0.838671,  -0.829038,  
  -0.819152,  -0.809017,  -0.798636,  -0.788011,  -0.777146,  
  -0.766044,  -0.754710,  -0.743145,  -0.731354,  -0.719340,  
  -0.707107,  -0.694658,  -0.681998,  -0.669131,  -0.656059,  
  -0.642788,  -0.629320,  -0.615661,  -0.601815,  -0.587785,  
  -0.573576,  -0.559193,  -0.544639,  -0.529919,  -0.515038,  
  -0.500000,  -0.484810,  -0.469472,  -0.453990,  -0.438371,  
  -0.422618,  -0.406737,  -0.390731,  -0.374607,  -0.358368,  
  -0.342020,  -0.325568,  -0.309017,  -0.292372,  -0.275637,  
  -0.258819,  -0.241922,  -0.224951,  -0.207912,  -0.190809,  
  -0.173648,  -0.156434,  -0.139173,  -0.121869,  -0.104528,  
  -0.087156,  -0.069756,  -0.052336,  -0.034899,  -0.017452,  
  -0.000000,  0.017452,  0.034899,  0.052336,  0.069756,  
  0.087156,  0.104528,  0.121869,  0.139173,  0.156434,  
  0.173648,  0.190809,  0.207912,  0.224951,  0.241922,  
  0.258819,  0.275637,  0.292372,  0.309017,  0.325568,  
  0.342020,  0.358368,  0.374607,  0.390731,  0.406737,  
  0.422618,  0.438371,  0.453990,  0.469472,  0.484810,  
  0.500000,  0.515038,  0.529919,  0.544639,  0.559193,  
  0.573576,  0.587785,  0.601815,  0.615661,  0.629320,  
  0.642788,  0.656059,  0.669131,  0.681998,  0.694658,  
  0.707107,  0.719340,  0.731354,  0.743145,  0.754710,  
  0.766044,  0.777146,  0.788011,  0.798636,  0.809017,  
  0.819152,  0.829038,  0.838671,  0.848048,  0.857167,  
  0.866025,  0.874620,  0.882948,  0.891007,  0.898794,  
  0.906308,  0.913545,  0.920505,  0.927184,  0.933580,  
  0.939693,  0.945519,  0.951057,  0.956305,  0.961262,  
  0.965926,  0.970296,  0.974370,  0.978148,  0.981627,  
  0.984808,  0.987688,  0.990268,  0.992546,  0.994522,  
  0.996195,  0.997564,  0.998630,  0.999391,  0.999848 };
/* t_sin[360] */
  
static double t_cos[360] =
{0.000000,  0.017452,  0.034899,  0.052336,  0.069756,  
  0.087156,  0.104528,  0.121869,  0.139173,  0.156434,  
  0.173648,  0.190809,  0.207912,  0.224951,  0.241922,  
  0.258819,  0.275637,  0.292372,  0.309017,  0.325568,  
  0.342020,  0.358368,  0.374607,  0.390731,  0.406737,  
  0.422618,  0.438371,  0.453990,  0.469472,  0.484810,  
  0.500000,  0.515038,  0.529919,  0.544639,  0.559193,  
  0.573576,  0.587785,  0.601815,  0.615661,  0.629320,  
  0.642788,  0.656059,  0.669131,  0.681998,  0.694658,  
  0.707107,  0.719340,  0.731354,  0.743145,  0.754710,  
  0.766044,  0.777146,  0.788011,  0.798636,  0.809017,  
  0.819152,  0.829038,  0.838671,  0.848048,  0.857167,  
  0.866025,  0.874620,  0.882948,  0.891007,  0.898794,  
  0.906308,  0.913545,  0.920505,  0.927184,  0.933580,  
  0.939693,  0.945519,  0.951057,  0.956305,  0.961262,  
  0.965926,  0.970296,  0.974370,  0.978148,  0.981627,  
  0.984808,  0.987688,  0.990268,  0.992546,  0.994522,  
  0.996195,  0.997564,  0.998630,  0.999391,  0.999848,  
  1.000000,  0.999848,  0.999391,  0.998630,  0.997564,  
  0.996195,  0.994522,  0.992546,  0.990268,  0.987688,  
  0.984808,  0.981627,  0.978148,  0.974370,  0.970296,  
  0.965926,  0.961262,  0.956305,  0.951057,  0.945519,  
  0.939693,  0.933580,  0.927184,  0.920505,  0.913545,  
  0.906308,  0.898794,  0.891007,  0.882948,  0.874620,  
  0.866025,  0.857167,  0.848048,  0.838671,  0.829038,  
  0.819152,  0.809017,  0.798636,  0.788011,  0.777146,  
  0.766044,  0.754710,  0.743145,  0.731354,  0.719340,  
  0.707107,  0.694658,  0.681998,  0.669131,  0.656059,  
  0.642788,  0.629320,  0.615661,  0.601815,  0.587785,  
  0.573576,  0.559193,  0.544639,  0.529919,  0.515038,  
  0.500000,  0.484810,  0.469472,  0.453990,  0.438371,  
  0.422618,  0.406737,  0.390731,  0.374607,  0.358368,  
  0.342020,  0.325568,  0.309017,  0.292372,  0.275637,  
  0.258819,  0.241922,  0.224951,  0.207912,  0.190809,  
  0.173648,  0.156434,  0.139173,  0.121869,  0.104528,  
  0.087156,  0.069756,  0.052336,  0.034899,  0.017452,  
  0.000000,  -0.017452,  -0.034899,  -0.052336,  -0.069756,  
  -0.087156,  -0.104528,  -0.121869,  -0.139173,  -0.156434,  
  -0.173648,  -0.190809,  -0.207912,  -0.224951,  -0.241922,  
  -0.258819,  -0.275637,  -0.292372,  -0.309017,  -0.325568,  
  -0.342020,  -0.358368,  -0.374607,  -0.390731,  -0.406737,  
  -0.422618,  -0.438371,  -0.453990,  -0.469472,  -0.484810,  
  -0.500000,  -0.515038,  -0.529919,  -0.544639,  -0.559193,  
  -0.573576,  -0.587785,  -0.601815,  -0.615661,  -0.629320,  
  -0.642788,  -0.656059,  -0.669131,  -0.681998,  -0.694658,  
  -0.707107,  -0.719340,  -0.731354,  -0.743145,  -0.754710,  
  -0.766044,  -0.777146,  -0.788011,  -0.798636,  -0.809017,  
  -0.819152,  -0.829038,  -0.838671,  -0.848048,  -0.857167,  
  -0.866025,  -0.874620,  -0.882948,  -0.891007,  -0.898794,  
  -0.906308,  -0.913545,  -0.920505,  -0.927184,  -0.933580,  
  -0.939693,  -0.945519,  -0.951057,  -0.956305,  -0.961262,  
  -0.965926,  -0.970296,  -0.974370,  -0.978148,  -0.981627,  
  -0.984808,  -0.987688,  -0.990268,  -0.992546,  -0.994522,  
  -0.996195,  -0.997564,  -0.998630,  -0.999391,  -0.999848,  
  -1.000000,  -0.999848,  -0.999391,  -0.998630,  -0.997564,  
  -0.996195,  -0.994522,  -0.992546,  -0.990268,  -0.987688,  
  -0.984808,  -0.981627,  -0.978148,  -0.974370,  -0.970296,  
  -0.965926,  -0.961262,  -0.956305,  -0.951057,  -0.945519,  
  -0.939693,  -0.933580,  -0.927184,  -0.920505,  -0.913545,  
  -0.906308,  -0.898794,  -0.891007,  -0.882948,  -0.874620,  
  -0.866025,  -0.857167,  -0.848048,  -0.838671,  -0.829038,  
  -0.819152,  -0.809017,  -0.798636,  -0.788011,  -0.777146,  
  -0.766044,  -0.754710,  -0.743145,  -0.731354,  -0.719340,  
  -0.707107,  -0.694658,  -0.681998,  -0.669131,  -0.656059,  
  -0.642788,  -0.629320,  -0.615661,  -0.601815,  -0.587785,  
  -0.573576,  -0.559193,  -0.544639,  -0.529919,  -0.515038,  
  -0.500000,  -0.484810,  -0.469472,  -0.453990,  -0.438371,  
  -0.422618,  -0.406737,  -0.390731,  -0.374607,  -0.358368,  
  -0.342020,  -0.325568,  -0.309017,  -0.292372,  -0.275637,  
  -0.258819,  -0.241922,  -0.224951,  -0.207912,  -0.190809,  
  -0.173648,  -0.156434,  -0.139173,  -0.121869,  -0.104528,  
  -0.087156,  -0.069756,  -0.052336,  -0.034899,  -0.017452};
/* t_cos[360] */

/* ----- */

void setheading (int angle)
{
  t_heading = angle % 360; /* avoid overflows */
}

/* ----- */

int heading (void)
{
  return (t_heading);
}

/* ----- */

void home (void)
{
  t_x = getmaxx () / 2;
  t_y = getmaxy () / 2;
  setheading (0);
}

/* ----- */

void forwd (int n)
{
#if __GNUC__
  short int newx, newy;
#else
  int newx, newy;
#endif
  /* why short int instead of int? I noticed a strange bug 
   * that occurs when compiling with gcc 4.6.3 on my Linux Mint 13.
   * Compiling with tcc or clang produces no errors. xvertext
   * memory leak in xbgi-ptoc, maybe?
   */
  
  newx = (int) ((double) n * t_cos[t_heading]);
  newy = (int) ((double) n * t_sin[t_heading]);
  
  /* is the turtle visible? */
  if (t_show_turtle && t_turtle_drawn)
    undraw_turtle ();
  
  /* should we draw? */
  if (t_pen_down)
    line (t_x, t_y, t_x + newx, t_y - newy);

  t_x += newx;
  t_y -= newy;
  
  if (t_show_turtle)
    draw_turtle ();
  
  /* is wrapping active? */
  if (t_turtle_wrap) {
    if (t_x < 0)
      t_x = getmaxx () - t_x;
    if (t_x > getmaxx ())
      t_x = t_x - getmaxx ();
    
    /* BUG HERE! using gcc, and defining t_y as integer, 
     * sometimes it overflows and turns < 0 */
    if (t_y < 0)
      t_y = getmaxy () - t_y;
    if (t_y > getmaxy ())
      t_y = t_y - getmaxy ();
  }
  
} /* forwd */

/* ----- */

void back (int n)
{
  turnleft (180);
  forwd (n);
  turnleft (180);
}

/* ----- */

void pendown (void)
{
  t_pen_down = T_TRUE;
}

/* ----- */

void penup (void)
{
  t_pen_down = T_FALSE;
}

/* ----- */

void turnleft (int n)
{
  t_heading -= n;
  if (t_heading < 0)
    t_heading += 360;
}

/* ----- */

void turnright (int n)
{
  t_heading += n;
  if (t_heading >= 360)
    t_heading -= 360;
}

/* ----- */

int xcor (void)
{
  return (t_x);
}

/* ----- */

int ycor (void)
{
  return (t_y);
}

/* ----- */

void draw_turtle (void)
{
  setwritemode(XOR_PUT);
  
  /* maybe too simple but convenient :-) */
  circle (t_x, t_y, 10);
  
  setwritemode(COPY_PUT);
  t_turtle_drawn = T_TRUE;
}

/* ----- */

void undraw_turtle (void)
{
  draw_turtle ();
  t_turtle_drawn = T_FALSE;
}

/* ----- */

void showturtle (void)
{
  draw_turtle ();
  t_show_turtle = T_TRUE;
}

/* ----- */

void hideturtle (void)
{
  draw_turtle ();
  t_show_turtle = T_FALSE;
}

/* ----- */

void setposition (int x, int y)
{
  t_x = x;
  t_y = y;
}

/* ----- */

void wrap (void)
{
  t_turtle_wrap = T_TRUE;
}

/* ----- */

void nowrap (void)
{
  t_turtle_wrap = T_FALSE;
}

/* ----- End of turtle.c */
