#!/usr/bin/env python
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
# 
# The contents of this file are subject to the Mozilla Public License
# Version 1.1 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
# 
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
# License for the specific language governing rights and limitations
# under the License.
# 
# The Original Code is Komodo code.
# 
# The Initial Developer of the Original Code is ActiveState Software Inc.
# Portions created by ActiveState Software Inc are Copyright (C) 2000-2007
# ActiveState Software Inc. All Rights Reserved.
# 
# Contributor(s):
#   ActiveState Software Inc
# 
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
# 
# ***** END LICENSE BLOCK *****

"""A place for generic string/text manipulation utilities. JavaScript
sucks for text manipulation.
"""

import sys
import os
import re

from xpcom import components, nsError, ServerException, COMException
import textutils

class KoTextUtils(object):
    _com_interfaces_ = [components.interfaces.koITextUtils]
    _reg_clsid_ = "{2b06fe9e-3852-41f5-87ea-56dcaa4d7345}"
    _reg_contractid_ = "@activestate.com/koTextUtils;1"
    _reg_desc_ = "Text manipulation utilities"

    def one_line_summary_from_text(self, text, length):
        return textutils.one_line_summary_from_text(text, length)

    def break_up_words(self, text, max_word_length):
        return textutils.break_up_words(text, max_word_length)

    def break_up_lines(self, text, max_line_width):
        return textutils.break_up_lines(text, max_line_width)

