// kfmacros.h
//
// Useful macros for kForth C and C++ source files, following
// the convention established by DNW in vm-osxppc.s
//
// Copyright (c) 2009--2011 Creative Consulting for Research and Education
// Provided under the GNU Lesser General Public License (LGPL)
//
// Revisions:
//   2009-09-20  km  factored from the files ForthVM.cpp and vmc.c
//   2009-11-27  km  added DROP  INC_DSP  DEC_DSP  TOS
//   2010-06-30  km  added IS_ADDR
//   2011-02-02  km  added PUSH_IVAL and PUSH_ADDR

#define INC_DSP   ++GlobalSp;
#define DEC_DSP   --GlobalSp;
#define TOS       (*GlobalSp)

#ifndef __FAST__

#define INC_DTSP  ++GlobalTp;
#define DEC_DTSP  --GlobalTp;
#define INC2_DTSP  GlobalTp += 2;
#define IS_ADDR   (*GlobalTp == OP_ADDR)
#define CHK_ADDR  if (*GlobalTp != OP_ADDR) return E_V_NOTADDR;
#define STD_IVAL  *GlobalTp-- = OP_IVAL;
#define STD_ADDR  *GlobalTp-- = OP_ADDR;
#define DROP      ++GlobalSp; ++GlobalTp;

#else

#define INC_DTSP 
#define DEC_DTSP 
#define INC2_DTSP
#define IS_ADDR    ( FALSE )
#define CHK_ADDR 
#define STD_IVAL
#define STD_ADDR
#define DROP       ++GlobalSp;

#endif

#define PUSH_IVAL(x) TOS = (x); DEC_DSP  STD_IVAL
#define PUSH_ADDR(x) TOS = (x); DEC_DSP  STD_ADDR
