\ lyx-included.4th
\
\  This program allows a LyX file containing documentation
\  and source to be directly included in a Forth environment.
\  It is based on an example given by Bernd Paysan on
\  comp.lang.forth, February 16, 2011. See message id.
\  <ijipt8$28n$1@news.m-online.net>
\
\ Usage:
\
\   $lyxfile $forthfile lyx-included
\
\ Example:
\
\    s" lpforth" s" gcd" lyx-included
\
\  will use the notangle program to extract and include the 
\  Forth source,  gcd.fs, from the LyX file, lpforth.lyx.
\
\ Requires:
\   ans-words.4th  (kForth only)
\   strings.x
\
\ Revisions:
\   2011-02-17  km  make use of strings.fs for string 
\                   handling; remove existing .nw file;
\                   require two arguments to lyx-include:
\                   the lyx filename and the Forth source
\                   filename.
\   2011-02-18  km  ported to kForth; replace use of
\                   OPEN-PIPE with generic SHELL command;
\                   used INCLUDED instead of INCLUDE-FILE;
\                   no requirement for persistence of S"
\                   strings.
\                   
\ Notes:
\
\  1) Set up instructions for LyX (for Linux). LaTeX and LyX are
\     already assumed to be installed:
\
\     a) Install the "noweb" package, if it is provided in your 
\        distribution. Otherwise, obtain the package from its
\        homepage and install it.
\
\     b) Run "texhash" as superuser, so that LaTeX knows about the 
\        noweb.sty stylesheet.
\
\     c) Start LyX and execute Reconfigure ( Tools > Reconfigure ).
\
\     d) Exit and restart LyX. You are now ready to do literate
\        Forth programming from LyX.
\
\     Separate tutorials may be found on the web for using LyX to
\     do literate programming. The chunk containing the Forth source
\     to be loaded must start with, <<filename.fs>>=
\
\     An example LyX file may be found at,
\
\         ftp://ccreweb.org/software/lyx/forth/lpforth.lyx
\
\
\  2) The current version should work on any ANS Forth system which
\     can define a suitable word for SHELL .

[undefined] strcat [IF]  s" strings" included  [THEN]
[undefined] a@     [IF]  : a@ @ ;              [THEN]

\ Define a generic SHELL to execute a shell command, passed as
\   a string, and return the error code.
\
\   shell  ( caddr u -- n )
\
1 [IF] : shell  strpck system ;        [THEN]  \ kforth
0 [IF] : shell  system ;               [THEN]  \ pfe
0 [IF] : shell  system  $? ;           [THEN]  \ gforth
0 [IF] : shell  system  RETURNCODE @ ; [THEN]  \ iForth

2variable src_name
2variable lyx_name

: $@ ( a -- astring u ) dup >r cell+ a@ r> @ ;

: lyx-included ( alyx u asrc u -- ) 
  \ s" filename" set-macro
  \ s" lyx -e literate %filename%.lyx; notangle -R%filename%.fs %filename%.nw"
  \ substitute
  
  strpck count s" .fs" strcat src_name 2!  
  strpck count lyx_name 2!
  s" rm " lyx_name $@ strcat s" .nw" strcat shell drop
  s"  lyx -e literate " lyx_name $@ strcat s" .lyx" strcat shell
  abort" Unable to extract a noweb file from lyx file!"
  s"  notangle -R" src_name $@ strcat s"  " strcat 
  lyx_name $@ strcat s" .nw > " strcat
  src_name $@ strcat shell
  abort" Unable to extract Forth source file!"
  src_name $@ included
; 


