\ hexterm.4th
\
\ Hex output terminal for kForth (based on terminal.4th)
\ 
\
\ Requires:
\
\       ans-words.4th
\       struct.4th
\       struct-ext.4th
\	strings.4th
\	ansi.4th
\	serial.4th
\
\ Revisions:
\       2007-08-03  revised to use new serial.4th, requiring structures  KM
include ans-words
include struct
include struct-ext
include strings
include ansi
include serial

variable com			
create buf 64 allot

: hexchar ( n -- ) dup 10 < if 48 + emit else 10 - 65 + emit then ;

: hprint ( n -- ) [char] < emit dup 4 rshift hexchar 
	15 and hexchar [char] > emit ;


: ht ( -- | terminal emulator )
	\ black background
	page
	\ green background
	\ black foreground
	." Touch Screen Terminal - (Esc) to Exit " cr
	\ white foreground
	\ black background
	
	COM1 serial_open com !
	com @ c" 8N1" serial_setparams
	com @ B9600 serial_setbaud

	begin
	  com @ serial_lenrx
	  if
	    com @ buf 1 serial_read drop
	    buf c@ hprint 
	  then
	  key?
	  if
	    key
	    dup
	    27 =
	    if
	      drop
	      com @ serial_close
	      drop
	      text_normal	\ restore normal foreground/background colors
	      \ page		\ clear the screen
	      exit
	    then
	    buf c!
	    com @ buf 1 serial_write drop
	  then
	again ;
		
." Type 'ht' to start hex terminal on COM1 at 9600, 8N1"




