\ dltest.4th
\
\ Test use of the experimental dynamic link library 
\ interface in kForth for x86-linux, v 1.4.6 and greater.
\
\ K. Myneni, krishna.myneni@ccreweb.org
\ Last Revised: 2009-09-30
\
\ Notes:
\
\ 1. The dynamic library interface is not yet fixed
\    in kForth, and may change prior to release. The
\    interface currently consists of the words
\    DLOPEN  DLSYM  DLERROR  DLCLOSE
\
\ 2. The example below is the standard man page example
\    for the dlopen() function, translated to Forth.
\
\ 3. In addition to loading a dynamic library and
\    obtaining symbol (function) addresses, a means of
\    calling a library function from Forth must be
\    implemented. The Forth to library function 
\    interface must push the required function args
\    onto the system stack, call the function, and 
\    return the result(s) on the Forth stack. An
\    interface word, FCALL0, specific to the test
\    example is given in assembly code, below.

include ans-words
include asm-x86.4th

base @
decimal

1 constant RTLD_LAZY

\ Interface for calling an external function which takes
\ one dfloat on the stack, and whose execution results
\ in a floating point result on the FPU stack.
\
\ addr is the library function address
CODE fcall0 ( r1 addr -- r2 )   \ integrated fp/data stack
    0 [ebx] eax mov,
    TCELL # ebx add,
    ebx push,
    4 [ebx] push,
    0 [ebx] push,
    eax call, 
    eax pop,
    eax pop,
    ebx pop,          \ restore Forth stack pointer
    0 [ebx] fstp,     \ replace arg with result on Forth stack
    0 # eax mov,
END-CODE


\ Length of a null-terminated string
: strlen ( addr -- len )
	0
	begin over c@ 
        while 1+ >r 1+ r> 
	repeat
	nip ;

: check-dlerror ( -- ) 
    dlerror dup IF  dup strlen cr type cr ABORT THEN drop ;

0 value hndLib
0 value pcos 
    
: dltest ( -- )
    c" libm.so" RTLD_LAZY dlopen to hndLib
    hndLib 0= IF check-dlerror THEN
    cr ." Opened the C math library, libm.so."

    hndLib c" cos" dlsym to pcos
    check-dlerror
    cr ." Loaded library function 'cos' at address " 
    pcos hex u. decimal

    2.0e pcos fcall0        \ call the library function

    cr ." 2.0e cos returns " fdup f. ."  which is "
    2.0e fcos f= IF ." correct." ELSE ." INCORRECT!" THEN 
    hndLib dlclose
    cr ." dlclose returned " .
;

dltest

base !

