/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.xml;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.FileDestination;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.OutputMethodHandlerImpl;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sweetohm.ant.util.Arg;
import net.sweetohm.ant.util.FileTask;
import org.apache.tools.ant.BuildException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XTask
extends FileTask
implements ErrorHandler {
    static XSLProcessorImpl xslprocessor;
    static OutputMethodHandlerImpl handler;
    String style;
    String todir;
    String tofile;
    String extension = ".html";
    Vector args = new Vector();
    boolean force = false;

    public void setStyle(String style) {
        this.style = style;
    }

    public void setTodir(String todir) {
        this.todir = todir;
    }

    public void setTofile(String tofile) {
        this.tofile = tofile;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void addArg(Arg arg) {
        this.args.addElement(arg);
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void execute() throws BuildException {
        File style = null;
        if (this.style != null) {
            style = this.getProject().resolveFile(this.style);
        }
        File todir = null;
        if (this.todir != null) {
            todir = this.getProject().resolveFile(this.todir);
        }
        File tofile = null;
        if (this.tofile != null) {
            tofile = this.getProject().resolveFile(this.tofile);
        }
        if (style == null) {
            throw new BuildException("Style attribute is mandatory.");
        }
        if (!style.exists()) {
            throw new BuildException("Style sheet " + style + " not found.");
        }
        if (tofile != null && !tofile.getParentFile().exists()) {
            throw new BuildException("Directory " + tofile.getParent() + " not found.");
        }
        if (todir != null && !todir.exists()) {
            throw new BuildException("Directory " + todir + " not found.");
        }
        if (xslprocessor == null) {
            xslprocessor = new XSLProcessorImpl();
            xslprocessor.setParser(XTask.getParser());
            xslprocessor.setErrorHandler((ErrorHandler)this);
            handler = new OutputMethodHandlerImpl((XSLProcessor)xslprocessor);
            xslprocessor.setOutputMethodHandler((OutputMethodHandler)handler);
        }
        int i = 0;
        while (i < this.args.size()) {
            Arg arg = (Arg)this.args.elementAt(i);
            xslprocessor.setParameter(arg.getName(), (Object)arg.getValue());
            ++i;
        }
        long xslDate = style.lastModified();
        Vector files = this.getFiles(true);
        int i2 = 0;
        while (i2 < files.size()) {
            try {
                long toDate;
                File file = (File)files.elementAt(i2);
                long xmlDate = file.lastModified();
                InputSource xmlSource = XTask.getInputSource(file);
                InputSource xslSource = XTask.getInputSource(style);
                if (tofile == null) {
                    String name = file.getName();
                    if (name.indexOf(".") >= 0) {
                        name = name.substring(0, name.lastIndexOf(".")) + this.extension;
                    }
                    tofile = new File(todir, name);
                }
                if ((toDate = tofile.lastModified()) < xslDate || toDate < xmlDate || this.force) {
                    this.log("Transforming: " + file.getPath());
                    handler.setDestination((Destination)new FileDestination(tofile));
                    xslprocessor.loadStylesheet(xslSource);
                    xslprocessor.parse(xmlSource);
                }
                tofile = null;
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage());
            }
            ++i2;
        }
    }

    protected static Parser getParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            return saxParser.getParser();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    protected static InputSource getInputSource(File file) {
        return new InputSource("file://" + file.getAbsolutePath());
    }

    public void warning(SAXParseException e) {
        this.printSAXParseException(e);
    }

    public void error(SAXParseException e) {
        this.printSAXParseException(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    void printSAXParseException(SAXParseException e) {
        String systemId = e.getSystemId();
        int lineNumber = e.getLineNumber();
        String message = "";
        if (systemId != null) {
            message = message + systemId + ":";
        }
        if (lineNumber >= 0) {
            message = message + lineNumber + ":";
        }
        if (systemId != null || lineNumber >= 0) {
            message = message + " ";
        }
        this.log(message + e.getMessage());
    }
}

