/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sweetohm.ant.util.FileTask;
import org.apache.tools.ant.BuildException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WordCountTask
extends FileTask {
    static final String FILE = "file:";
    String separators = " \t\n\r.,:;!?\"(){}[]+-*/=<>0123456789&#$\u00a3%|_@\u00b0";
    SAXParser parser;
    Handler handler = new Handler();
    List excludeElements = new ArrayList();
    List singleElements = new ArrayList();
    Map includeAttributes = new HashMap();
    List include = new ArrayList();
    int nbWords;
    int nbFiles;
    String property;
    String propertyFiles;
    boolean quiet;

    public WordCountTask() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        this.parser = factory.newSAXParser();
    }

    public void setSeparators(String separators) {
        this.separators = separators;
    }

    public void setExcludeElements(String excludeList) {
        StringTokenizer st = new StringTokenizer(excludeList.trim(), " ,");
        while (st.hasMoreTokens()) {
            this.excludeElements.add(st.nextToken().trim());
        }
        this.log("Excluding elements: " + this.excludeElements, 4);
    }

    public void setSingleElements(String singleList) {
        StringTokenizer st = new StringTokenizer(singleList.trim(), " ,");
        while (st.hasMoreTokens()) {
            this.singleElements.add(st.nextToken().trim());
        }
        this.log("Single elements: " + this.singleElements, 4);
    }

    public void setIncludeAttributes(String includeList) {
        StringTokenizer st = new StringTokenizer(includeList.trim(), " ,");
        while (st.hasMoreTokens()) {
            String elatt = st.nextToken().trim();
            String element = elatt.substring(0, elatt.indexOf("@")).trim();
            String attribute = elatt.substring(elatt.indexOf("@") + 1).trim();
            ArrayList<String> atts = (ArrayList<String>)this.includeAttributes.get(element);
            if (atts == null) {
                atts = new ArrayList<String>();
            }
            atts.add(attribute);
            this.includeAttributes.put(element, atts);
        }
        this.log("Excluding elements: " + this.excludeElements, 4);
    }

    public void setDocumentProperties(String file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.getProject().resolveFile(file)));
        }
        catch (Exception e) {
            throw new BuildException("Error loading the document properties file");
        }
        if (properties.getProperty("separators") != null) {
            this.setSeparators(properties.getProperty("separators") + " ");
        }
        this.log("Separators: " + properties.getProperty("separators"), 4);
        if (properties.getProperty("excludeElements") != null) {
            this.setExcludeElements(properties.getProperty("excludeElements"));
        }
        this.log("Exclude Elements: " + properties.getProperty("excludeElements"), 4);
        if (properties.getProperty("singleElements") != null) {
            this.setSingleElements(properties.getProperty("singleElements"));
        }
        this.log("Single Elements: " + properties.getProperty("singleElements"), 4);
        if (properties.getProperty("includeAttributes") != null) {
            this.setIncludeAttributes(properties.getProperty("includeAttributes"));
        }
        this.log("Include Attributes: " + properties.getProperty("includeAttributes"), 4);
    }

    public void setProperty(String property) {
        this.property = property;
        this.log("Property: " + property, 4);
    }

    public void setPropertyFiles(String propertyFiles) {
        this.propertyFiles = propertyFiles;
        this.log("Property for Files: " + this.property, 4);
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void execute() throws BuildException {
        this.nbWords = 0;
        this.nbFiles = 0;
        Vector files = this.getFiles(true);
        int i = 0;
        while (i < files.size()) {
            ++this.nbFiles;
            File file = (File)files.elementAt(i);
            this.log("Processing File: " + file, 4);
            try {
                this.parser.parse(file, (DefaultHandler)this.handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("Error while parsing.");
            }
            ++i;
        }
        if (this.property != null) {
            this.project.setProperty(this.property, Integer.toString(this.nbWords));
        }
        if (this.propertyFiles != null) {
            this.project.setProperty(this.propertyFiles, Integer.toString(this.nbFiles));
        }
        if (!this.quiet) {
            this.log(this.nbWords + " words in " + this.nbFiles + " file(s).");
        }
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            boolean isIncluded = !WordCountTask.this.excludeElements.contains(qName);
            boolean isSingle = WordCountTask.this.singleElements.contains(qName);
            if (isSingle) {
                ++WordCountTask.this.nbWords;
                isIncluded = false;
            }
            if (WordCountTask.this.include.size() > 0 && !((Boolean)WordCountTask.this.include.get(WordCountTask.this.include.size() - 1)).booleanValue()) {
                isIncluded = false;
            }
            WordCountTask.this.include.add(new Boolean(isIncluded));
            WordCountTask.this.log("Include element " + qName + ": " + isIncluded, 4);
            List attList = (List)WordCountTask.this.includeAttributes.get(qName);
            if (attList != null) {
                int i = 0;
                while (i < attList.size()) {
                    String att = (String)attList.get(i);
                    String text = atts.getValue(att);
                    if (text != null) {
                        this.countWords(text);
                    }
                    ++i;
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            WordCountTask.this.include.remove(WordCountTask.this.include.size() - 1);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (((Boolean)WordCountTask.this.include.get(WordCountTask.this.include.size() - 1)).booleanValue()) {
                String text = new String(ch, start, length);
                this.countWords(text);
            }
        }

        void countWords(String text) {
            if ((text = text.trim()).length() == 0) {
                return;
            }
            StringTokenizer st = new StringTokenizer(text, WordCountTask.this.separators);
            WordCountTask.this.nbWords += st.countTokens();
        }

        public void warning(SAXParseException e) throws SAXException {
            this.printError(e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.printError(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.printError(e);
        }

        void printError(SAXParseException e) throws SAXException {
            String systemId = e.getSystemId();
            if (systemId.startsWith(WordCountTask.FILE)) {
                systemId = systemId.substring(WordCountTask.FILE.length());
            }
            int lineNumber = e.getLineNumber();
            String message = "";
            if (systemId != null) {
                message = message + systemId + ":";
            }
            if (lineNumber >= 0) {
                message = message + lineNumber + ":";
            }
            if (systemId != null || lineNumber >= 0) {
                message = message + " ";
            }
            WordCountTask.this.log(message + e.getMessage());
        }
    }
}

