/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.xml;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sweetohm.ant.util.FileTask;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidTask
extends FileTask {
    boolean dtd = true;
    boolean failonerror = true;
    static final int WARNING = 0;
    static final int ERROR = 1;
    static final int FATAL = 2;
    int errorlevel = 2;
    static final String FILE = "file:";
    int errorCount = 0;
    int maxerrors = 100;

    public void setDtd(boolean dtd) {
        this.dtd = dtd;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setErrorlevel(String errorlevel) {
        if (errorlevel.equals("warning")) {
            this.errorlevel = 0;
        } else if (errorlevel.equals("error")) {
            this.errorlevel = 1;
        } else if (errorlevel.equals("fatal")) {
            this.errorlevel = 2;
        } else {
            throw new BuildException("Illegal error level (possible values are 'warning', 'error' or 'fatal')");
        }
    }

    public void setMaxerrors(String maxerrors) {
        try {
            this.maxerrors = Integer.parseInt(maxerrors);
        }
        catch (NumberFormatException e) {
            throw new BuildException("The value of attribute 'maxerrors' should be an integer.");
        }
        if (this.maxerrors < 1) {
            throw new BuildException("Max number of errors must be greater than 0.");
        }
    }

    public void execute() throws BuildException {
        SAXParser parser = this.getParser();
        Handler handler = new Handler();
        Vector files = this.getFiles(true);
        int i = 0;
        while (i < files.size()) {
            File file = (File)files.elementAt(i);
            this.log("Validating file '" + file.getName() + "'...");
            try {
                parser.parse(file, (DefaultHandler)handler);
            }
            catch (SAXParsingInterruptedException e) {
                this.log(e.getMessage());
                if (this.failonerror) {
                    throw new BuildException("Parsing error.");
                }
            }
            catch (SAXException e) {
                throw new BuildException("Unknown error while parsing.");
            }
            catch (IOException e) {
                throw new BuildException("IO error while parsing.");
            }
            if (this.errorCount > 0 && this.failonerror) {
                throw new BuildException("Parsing error.");
            }
            ++i;
        }
    }

    SAXParser getParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(this.dtd);
            return factory.newSAXParser();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    class SAXParsingInterruptedException
    extends SAXException {
        SAXParsingInterruptedException() {
            super("Parsing interrupted.");
        }
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            if (ValidTask.this.errorlevel <= 0) {
                this.printError(e);
            }
        }

        public void error(SAXParseException e) throws SAXException {
            if (ValidTask.this.errorlevel <= 1) {
                this.printError(e);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.printError(e);
        }

        void printError(SAXParseException e) throws SAXException {
            ++ValidTask.this.errorCount;
            if (ValidTask.this.errorCount > ValidTask.this.maxerrors) {
                throw new SAXParsingInterruptedException();
            }
            String systemId = e.getSystemId();
            if (systemId.startsWith(ValidTask.FILE)) {
                systemId = systemId.substring(ValidTask.FILE.length());
            }
            int lineNumber = e.getLineNumber();
            String message = "";
            if (systemId != null) {
                message = message + systemId + ":";
            }
            if (lineNumber >= 0) {
                message = message + lineNumber + ":";
            }
            if (systemId != null || lineNumber >= 0) {
                message = message + " ";
            }
            ValidTask.this.log(message + e.getMessage());
        }
    }
}

